/**
 *
 * @file crossbar_factory_vhd.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: crossbar_factory_vhd.cc 1956 2011-08-22 14:41:32Z lehton87 $
 *
 */


#include "crossbar_factory_vhd.hh"


#include <string>
#include <stdexcept>
#include <iostream>
#include <map>

namespace sctg
{

   static int findGeneric(std::map<std::string, int>& m,
			  const std::string& s, 
			  int def)
   {
      if(m.find(s) != m.end())
      {
	 std::cout << "Generic " << s << " set to value " << m[s] << std::endl;
	 return m[s];
      }
      else
      {
	 std::cout << "Generic " << s 
		   << " set to default value " << def << std::endl;
	 return def;
      }
   }

   namespace crossbar_vhd
   {

      CrossbarFactoryVHD::CrossbarFactoryVHD(sctg::NocConfIf* nocConfIf)
      :
	 xbar3(0),
	 xbar4(0),
	 xbar5(0),
	 xbar6(0),
	 xbar7(0),
	 xbar8(0),
	 xbar16(0),
	 xbar32(0),
	 xbar64(0)
      {
	 std::string subtype = nocConfIf->getNocSubType();
	 std::map<std::string, int> nodes = nocConfIf->getGenerics();



	 int pkt_switch_en_g = findGeneric(nodes, "pkt_switch_en_g", 0);
	 int stfwd_en_g = findGeneric(nodes, "stfwd_en_g", 0);
	 int addr_width_g = findGeneric(nodes, "addr_width_g", 32);
	 int packet_length_g = findGeneric(nodes, "packet_length_g", 8);
	 int timeout_g = findGeneric(nodes, "timeout_g", 4);
	 int fill_packet_g = findGeneric(nodes, "fill_packet_g", 0);
	 int len_flit_en_g = findGeneric(nodes, "len_flit_en_g", 0);
	 int oaddr_flit_en_g = findGeneric(nodes, "oaddr_flit_en_g", 0);
	 int fifo_depth_g = findGeneric(nodes, "fifo_depth_g", 0);
	 int noc_freq_g = findGeneric(nodes, "noc_freq_g", 50000000);
	 int ip_freq_g = findGeneric(nodes, "ip_freq_g", 50000000);

	 if(subtype == "3")
	 {
	    xbar3 = new crossbar_with_pkt_codec_vhd_bfm<3, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "4")
	 {
	    xbar4 = new crossbar_with_pkt_codec_vhd_bfm<4, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "5")
	 {
	    xbar5 = new crossbar_with_pkt_codec_vhd_bfm<5, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "6")
	 {
	    xbar6 = new crossbar_with_pkt_codec_vhd_bfm<6, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "7")
	 {
	    xbar7 = new crossbar_with_pkt_codec_vhd_bfm<7, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "8")
	 {
	    xbar8 = new crossbar_with_pkt_codec_vhd_bfm<8, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "16")
	 {
	    xbar16 = new crossbar_with_pkt_codec_vhd_bfm<16, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "32")
	 {
	    xbar32 = new crossbar_with_pkt_codec_vhd_bfm<32, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "64")
	 {
	    xbar64 = new crossbar_with_pkt_codec_vhd_bfm<64, 32, 8>
	       ("crossbar_with_pkt_codec", nocConfIf,
		pkt_switch_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else
	 {
	    std::ostringstream oss;
	    oss << "CrossbarFactory (VHDL) unsupported subtype \""
		<< subtype << "\"";
	    throw std::runtime_error(oss.str().c_str());
	 }

      }

      CrossbarFactoryVHD::~CrossbarFactoryVHD()
      {
      }


   }
}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

