/*
 * Created on 20.7.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.ui.xml.test;

import java.util.List;

import fi.cpu.ui.xml.XML_Source_FPGA;
import fi.cpu.xml.bind.configuration.ConfigurationType;
import fi.cpu.xml.bind.configuration.CpuType;
import fi.cpu.xml.bind.configuration.ProcessType;
import fi.cpu.xml.bind.configuration.ThreadType;
import fi.cpu.xml.bind.measurement.GraphType;
import fi.cpu.xml.bind.measurement.MeasurementType;

/**
 * @author Timo Vanhatupa
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class Test {

	public static void main(String[] args) {

		final String CONFIG_TEST_XML = "<configuration>\n\t<cpu id='0'>\n\t\t<thread id='0' priority='5'>\n\t\t\t<process id='0' name='rca'/>\n\t\t\t<process id='2' name='test'/>\n\t\t</thread>\n\t\t<thread id='1' priority='3'>\n\t\t</thread>\n\t</cpu>\n\t<cpu id='1'>\n\t</cpu>\n</configuration>";
		final String MEASUREMENT_TEST_XML = "<measurement>\n\t<graph id='0' cpu_id='0' value='100'/>\n\t<graph id='1' cpu_id='1' value='234'/>\n</measurement>";

		XML_Source_FPGA fpga = new XML_Source_FPGA();

		ConfigurationType config = fpga.getConfiguration(CONFIG_TEST_XML);
		
		List cpuList = config.getCpu();
	
		for (int i = 0; i < cpuList.size(); i++) {
			CpuType cpu = (CpuType)cpuList.get(i);
			System.out.println("CPU, id=" + cpu.getId());
			
			List threadList = cpu.getThread();
			
			for (int j = 0; j < threadList.size(); j++) {
				ThreadType thread = (ThreadType)threadList.get(j);
				System.out.println("\tTHREAD, id=" + thread.getId() + " priority=" + thread.getPriority());
				
				List processList = thread.getProcess();
				
				for (int k = 0; k < processList.size(); k++) {
					ProcessType process = (ProcessType)processList.get(k);
					System.out.println("\t\tPROCESS, id=" + process.getId() + " name=" + process.getName());				
				}	
			}
		}
		
		MeasurementType me = fpga.getMeasurement(MEASUREMENT_TEST_XML);

		List graphList = me.getGraph();
		
		for (int i = 0; i < graphList.size(); i++) {
			Object listItem = graphList.get(i);
			if (listItem instanceof GraphType) {
				GraphType graph = (GraphType)listItem;
				System.out.println("GRAPH, id=" + graph.getId() + " cpu_id=" + graph.getCpuId() + " value=" + graph.getValue());
			}
		}
	}
}