/**
 * File:    ServiceVertexView.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 6.3.2007
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.ui.service;

import java.awt.geom.Point2D;

import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;


/**
 * ServiceVertexView is the view object for service vertices.
 */
public class ServiceVertexView extends VertexView {
	private static ServiceVertexRenderer serviceRenderer = new ServiceVertexRenderer();
	
	/**
	 * Creates a new ServiceVertexView.
	 */
	public ServiceVertexView() {
		super();
	}
	
	
	/**
	 * Creates a new ServiceVertexView.
	 * @param cell The model object to be viewed.
	 */
	public ServiceVertexView(Object cell) {
		super(cell);
	}
	
	
	/* (non-Javadoc)
	 * @see org.jgraph.graph.AbstractCellView#getRenderer()
	 */
	public CellViewRenderer getRenderer() {
		return serviceRenderer;
	}
	
	
	/* (non-Javadoc)
	 * @see org.jgraph.graph.CellView#getPerimeterPoint(org.jgraph.graph.EdgeView, java.awt.geom.Point2D, java.awt.geom.Point2D)
	 */
	public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
		return serviceRenderer.getPerimeterPoint(this, source, p);
	}
}
