/**
 * CVS:
 * $Id: ReportPanel.java 1399 2010-08-26 13:56:45Z lehton87 $
 * 
 * File:    ReportPanel.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 1.12.2006
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.ui.report;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.JPanel;

import fi.cpu.data.Configuration;
import fi.cpu.data.Model;
import fi.cpu.data.ModelNode;
import fi.cpu.data.ProcessingElement;
import fi.cpu.event.ModelEvent;
import fi.cpu.event.ModelListener;


/**
 * A panel for showing report information.
 */
public class ReportPanel extends JPanel {
	protected Configuration config;
	protected Map<String, ProcessorPanel> pePanels;
	
	
	/**
	 * Creates a new ReportPanel.
	 */
	public ReportPanel(Configuration config) {
		super();
		this.config = config;
		config.getPeModel().addModelListener(new MyModelListener());
		
		pePanels = new HashMap<String, ProcessorPanel>();

		setLayout(new GridLayout(0,3));

		initPanel();
	}

	
	/**
	 * Initializes the panel.
	 */
	public void initPanel() {
		pePanels.clear();
		
		Model peModel = config.getPeModel();
        Iterator<ModelNode> tIter = peModel.getChildren(peModel.getModelRoot()).iterator();

        while (tIter.hasNext()) {
        	ModelNode node = tIter.next();
        	if (!(node instanceof ProcessingElement)) {
        		continue;
        	}
        	ProcessingElement pe = (ProcessingElement) node;
        	pePanels.put(pe.getId(), new ProcessorPanel(pe));
        }
        drawPePanels();
	}

	
    /**
     * Draws processing element panels.
     */
    protected void drawPePanels() {
    	// Clear old panels
		removeAll();

		// Sort panels
		ArrayList<ProcessorPanel> pList = new ArrayList<ProcessorPanel>(pePanels.values());
		Collections.sort(pList);
		
		// Add new panels
		Iterator<ProcessorPanel> pIter = pList.iterator();
		while (pIter.hasNext()) {
			add(pIter.next());
		}
		
		validate();
		repaint();
    }
    
    
    /**
     * Listener for ModelEvents.
     */
    private class MyModelListener implements ModelListener {
    	public void nodeInserted(ModelEvent e) {
    		ModelNode parent = e.getCurrentParent();
    		if (parent != null && parent.equals(config.getPeModel().getModelRoot())) {
    			// Processing elements changed.
    			initPanel();
    		}
    	}
    	public void nodeRemoved(ModelEvent e) {
    		ModelNode oldParent = e.getOldParent();
    		
    		if (oldParent != null && oldParent.equals(config.getPeModel().getModelRoot())) {
    			// Processing elements changed.
    			initPanel();
    		}
    	}
    	public void nodeMoved(ModelEvent e) {
    		ModelNode parent = e.getCurrentParent();
    		ModelNode oldParent = e.getOldParent();
    		
    		if ((parent != null && parent.equals(config.getPeModel().getModelRoot()))
    				|| (oldParent != null && oldParent.equals(config.getPeModel().getModelRoot()))) {
    			// Processing elements changed.
    			initPanel();
    		}
    	}
    	public void structureChanged(ModelEvent e) {
    		ModelNode node = e.getNode();
    		
    		if (node != null && node.equals(config.getPeModel().getModelRoot())) {
    			// Structure changed starting from the root.
    			initPanel();
    		}
    	}
    }
}
