/*
 * CVS-tietoja:
 * $Author: jantti2 $ 
 * $Date: 2006-10-27 12:39:15 +0300 (pe, 27 loka 2006) $ 
 * $Revision: 2670 $
 *
 * Created on 10.10.2005
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *
 */
package fi.cpu.tcp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import fi.cpu.handler.DataHandler;

/**
 * @author jsikio
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class TCPClient extends DataHandler
{
    
    private class Runner implements Runnable
    {

        /* (non-Javadoc)
         * @see java.lang.Runnable#run()
         */
        public void run()
        {
        	
            while( true )
            {
            	while ( bufferedReader_ == null )
            	{
            		try {
						sleep(500);
					} catch (InterruptedException e) {
					}
            	}
            	
                readData();
            }
        }
        
    }

    private String ip_ = null;

    private int port_ = 0;

    private Socket socket_ = null;

    private boolean read_ = true;
    
    public TCPClient( String ip, Integer port )
    {
        ip_ = ip;
        port_ = port.intValue();

        initConnection();

        super.start();
        
       new Thread( new Runner() ).start();
        
    }

    private TCPClient()
    {
    }

    public void disconnect()
    {
        try
        {
            read_ = false;
            if( socket_ != null )
            {
                socket_.close();
            }
            socket_ = null;
            bufferedReader_ = null;
            byteReader_ = null;
            bufferedWriter_ = null;
            byteWriter_ = null;
        }
        catch ( IOException e )
        {
            e.printStackTrace();
        }
    }

    /**
     * Alustaa yhteyden
     */
    private void initConnection()
    {
        try
        {
        	System.out.println("Connecting to " + ip_ + ":" + port_);
            socket_ = new Socket( ip_, port_ );
            //Buffered reader
            bufferedReader_ = new BufferedReader( new InputStreamReader(
                    socket_.getInputStream() ) );
            byteReader_ = socket_.getInputStream();

            //Buffered writer (write Strings etc)
            bufferedWriter_ = new BufferedWriter( new OutputStreamWriter(
                    socket_.getOutputStream() ) );
            //OuputStream for writing bytes.
            byteWriter_ = socket_.getOutputStream();
        }
        catch ( UnknownHostException e )
        {
            e.printStackTrace();
        }
        catch ( IOException e )
        {
            e.printStackTrace();
        }

    }

    /* (non-Javadoc)
     * @see fi.cpu.handler.Handler#reconnect()
     */
    public void reconnect()
    {
        disconnect();
        initConnection();
    }
    
}
