/**
 * File:    ReportTableHeaderRenderer.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 27.3.2007
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.table;

import java.awt.Color;
import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import fi.cpu.Settings;


/**
 * Renderer for report table header cells.
 */
public class ReportTableHeaderRenderer extends DefaultTableCellRenderer {
    protected static final Color HEADER_BACKGROUND;

	static {
        int red = 0;
        int green = 0;
        int blue = 0;
        
        red = Integer.parseInt( Settings.getAttributeValue("PROCESS_BACKGROUND_DEFAULT_COLOR_RED") );
        green = Integer.parseInt( Settings.getAttributeValue("PROCESS_BACKGROUND_DEFAULT_COLOR_GREEN") );
        blue = Integer.parseInt( Settings.getAttributeValue("PROCESS_BACKGROUND_DEFAULT_COLOR_BLUE") );
        HEADER_BACKGROUND = new Color(red, green, blue);
	}

	
	/**
	 * Creates a new ReportTableHeaderRenderer.
	 */
	public ReportTableHeaderRenderer() {
		super();
		setBackground(HEADER_BACKGROUND);
	}
	
	
	/* (non-Javadoc)
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(
			JTable table, Object value, boolean isSelected,
			boolean hasFocus, int row, int column) {
		
		Component comp =  super.getTableCellRendererComponent(table, value,
				isSelected, hasFocus, row, column);
		
		if (comp instanceof JComponent) {
			JComponent jComp = (JComponent) comp;
			jComp.setBorder(BorderFactory.createEtchedBorder());
		}
		return comp;
	}
}
