/**
 * File:    Chart.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 30.3.2007
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.data;

import java.awt.Rectangle;

/**
 * Chart contains configuration information of a data chart.
 */
public class Chart {
    private String id;
    private String title;
    private String xAxis;
    private String yAxis;
    private int typeId;
    private double maxValue;
    private double minValue;
    private double length;
    private boolean autoScale;
    private boolean logged;
    private Rectangle bounds;
    
    /**
     * Creates a new Chart.
     */
    public Chart(String id, int typeId, String title,
    		String xAxis, String yAxis, double minValue, double maxValue,
    		double length, boolean autoScale, boolean logged) {
    	this.id = id;
    	this.typeId = typeId;
    	this.title = title;
    	this.xAxis = xAxis;
    	this.yAxis = yAxis;
    	this.minValue = minValue;
    	this.maxValue = maxValue;
    	this.length = length;
    	this.autoScale = autoScale;
    	this.logged = logged;
    	
    	bounds = null;
    }

	/**
	 * @return Returns the autoScale.
	 */
	public boolean isAutoScale() {
		return autoScale;
	}

	/**
	 * @param autoScale The autoScale to set.
	 */
	public void setAutoScale(boolean autoScale) {
		this.autoScale = autoScale;
	}

	/**
	 * @return Returns the bounds.
	 */
	public Rectangle getBounds() {
		return bounds;
	}

	/**
	 * @param bounds The bounds to set.
	 */
	public void setBounds(Rectangle bounds) {
		this.bounds = bounds;
	}

	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return Returns the length.
	 */
	public double getLength() {
		return length;
	}

	/**
	 * @param length The length to set.
	 */
	public void setLength(double length) {
		this.length = length;
	}

	/**
	 * @return Returns the maxValue.
	 */
	public double getMaxValue() {
		return maxValue;
	}

	/**
	 * @param maxValue The maxValue to set.
	 */
	public void setMaxValue(double maxValue) {
		this.maxValue = maxValue;
	}

	/**
	 * @return Returns the minValue.
	 */
	public double getMinValue() {
		return minValue;
	}

	/**
	 * @param minValue The minValue to set.
	 */
	public void setMinValue(double minValue) {
		this.minValue = minValue;
	}

	/**
	 * @return Returns the title.
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title The title to set.
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return Returns the typeId.
	 */
	public int getTypeId() {
		return typeId;
	}

	/**
	 * @param typeId The typeId to set.
	 */
	public void setTypeId(int typeId) {
		this.typeId = typeId;
	}

	/**
	 * @return Returns the xAxis.
	 */
	public String getXAxis() {
		return xAxis;
	}

	/**
	 * @param axis The xAxis to set.
	 */
	public void setXAxis(String axis) {
		xAxis = axis;
	}

	/**
	 * @return Returns the yAxis.
	 */
	public String getYAxis() {
		return yAxis;
	}

	/**
	 * @param axis The yAxis to set.
	 */
	public void setYAxis(String axis) {
		yAxis = axis;
	}

	/**
	 * @return Returns the logged.
	 */
	public boolean isLogged() {
		return logged;
	}

	/**
	 * @param logged The logged to set.
	 */
	public void setLogged(boolean logged) {
		this.logged = logged;
	}
}
