/**
 *
 * @file tcp_server.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: tcp_server.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#include "tcp_server.hh"

namespace sctg
{

   TcpServer::TcpServer(unsigned int port)
      : 
      _io(),
      _acceptor(_io, boost::asio::ip::tcp::endpoint(boost::asio::ip::tcp::v4(),
						    port)),
      _socket(_io)
   {
   }

   TcpServer::~TcpServer()
   {
   }

   void TcpServer::waitConnection()
   {
      _acceptor.accept(_socket);
   }

   void TcpServer::send(std::string& str)
   {
      boost::system::error_code err;
      boost::asio::write(_socket, boost::asio::buffer(str),
			 boost::asio::transfer_all(), err);
   }

}



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
