/**
 *
 * @file common.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: common.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef SCTG_COMMON_HH
#define SCTG_COMMON_HH

#include <string>
#include <systemc>

namespace sctg
{
  enum OperationType  {EXECUTE, SEND, READ, POLL};
  enum State {RUN, READY, WAIT, FREE};

  struct PeMeasurements
  {
    unsigned long int idleCycles;
    unsigned long int execCycles;
    sc_core::sc_time idleTime;
    sc_core::sc_time execTime;

    PeMeasurements()
      : idleTime(),
	execTime()
    {
      idleCycles = 0;
      execCycles = 0;
    }
  };

  struct BufferMeasurements
  {
    unsigned long int rxBytes;    
    unsigned long int txBytes;
    unsigned long int internalBytes;
    unsigned long int rxUsed;
    unsigned long int txUsed;

    BufferMeasurements()
    {
      rxBytes = 0;
      txBytes = 0;
      internalBytes = 0;
      rxUsed = 0;
      txUsed = 0;
    };
  };

  std::string stateToString(State state);

}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
