/**
 *
 * @file enc_dec_1d.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: enc_dec_1d.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#ifndef ASEBT_SC_RTL_2_ANC_DEC_1D_HH
#define ASEBT_SC_RTL_2_ANC_DEC_1D_HH

#include "packet_encoder_decoder.hh"

#include <systemc>
#include <sstream>

namespace asebt
{
namespace sc_rtl_2
{

   template <int n_ag_g            = 4, 
	     int wait_empty_fifo_g = 0, 
	     int data_width_g      = 36, 
	     int addr_width_g      = 32, 
	     int packet_length_g   = 8, 
	     int tx_len_width_g    = 8, 
	     int timeout_g         = 0, 
	     int fill_packet_g     = 0, 
	     int lut_en_g          = 1, 
	     int net_type_g        = 0, 
	     int len_flit_en_g     = 1, 
	     int oaddr_flit_en_g   = 1, 
	     int status_en_g       = 0>
   class enc_dec_1d : public sc_core::sc_module
   {
   public:
      sc_core::sc_in_clk                              clk;
      sc_core::sc_in<bool>               rst_n;
      sc_core::sc_in<bool>               av_ip_enc_in[n_ag_g];
      sc_core::sc_in<sc_dt::sc_bv<data_width_g> >   data_ip_enc_in[n_ag_g];
      sc_core::sc_in<bool>               we_ip_enc_in[n_ag_g];
      sc_core::sc_in<sc_dt::sc_bv<tx_len_width_g> > len_ip_enc_in[n_ag_g];
      sc_core::sc_out<bool>              full_enc_ip_out[n_ag_g];
      sc_core::sc_out<bool>              empty_enc_ip_out[n_ag_g];
      sc_core::sc_out<bool>              av_enc_net_out[n_ag_g];
      sc_core::sc_out<sc_dt::sc_bv<data_width_g> >  data_enc_net_out[n_ag_g];
      sc_core::sc_out<bool>              we_enc_net_out[n_ag_g];
      sc_core::sc_in<bool>               full_net_enc_in[n_ag_g];
      sc_core::sc_in<bool>               empty_net_enc_in[n_ag_g];
      sc_core::sc_in<sc_dt::sc_bv<data_width_g> >   data_net_dec_in[n_ag_g];
      sc_core::sc_out<bool>              re_dec_net_out[n_ag_g];
      sc_core::sc_in<bool>               full_net_dec_in[n_ag_g];
      sc_core::sc_in<bool>               empty_net_dec_in[n_ag_g];
      sc_core::sc_out<bool>              av_dec_ip_out[n_ag_g];
      sc_core::sc_out<sc_dt::sc_bv<data_width_g> >  data_dec_ip_out[n_ag_g];
      sc_core::sc_in<bool>               re_ip_dec_in[n_ag_g];
      sc_core::sc_out<bool>              empty_dec_ip_out[n_ag_g];


      enc_dec_1d(sc_core::sc_module_name name)
	 : sc_core::sc_module(name),
	   clk("clk"),
	   rst_n("rst_n")
      {
	 for(unsigned int i = 0; i < n_ag_g; ++i)
	 {
	    std::ostringstream oss;
	    oss << "encoder_decoder_for_agent_" << i;

	    encoder_decoders[i] = new packet_encoder_decoder
	       <wait_empty_fifo_g,
	       data_width_g,
	       addr_width_g,
	       tx_len_width_g,
	       packet_length_g,
	       timeout_g,
	       fill_packet_g,
	       lut_en_g,
	       net_type_g,
	       len_flit_en_g,
	       oaddr_flit_en_g,
	       status_en_g>(oss.str().c_str());

	    encoder_decoders[i]->clk(clk);
	    encoder_decoders[i]->rst_n(rst_n);

	    encoder_decoders[i]->av_ip_enc_in(av_ip_enc_in[i]);
	    encoder_decoders[i]->data_ip_enc_in(data_ip_enc_in[i]);
	    encoder_decoders[i]->we_ip_enc_in(we_ip_enc_in[i]);
	    encoder_decoders[i]->len_ip_enc_in(len_ip_enc_in[i]);
	    encoder_decoders[i]->full_enc_ip_out(full_enc_ip_out[i]);
	    encoder_decoders[i]->empty_enc_ip_out(empty_enc_ip_out[i]);
	    
	    encoder_decoders[i]->av_enc_net_out(av_enc_net_out[i]);
	    encoder_decoders[i]->data_enc_net_out(data_enc_net_out[i]);
	    encoder_decoders[i]->we_enc_net_out(we_enc_net_out[i]);
	    encoder_decoders[i]->full_net_enc_in(full_net_enc_in[i]);
	    encoder_decoders[i]->empty_net_enc_in(empty_net_enc_in[i]);
	    
	    encoder_decoders[i]->data_net_dec_in(data_net_dec_in[i]);
	    encoder_decoders[i]->re_dec_net_out(re_dec_net_out[i]);
	    encoder_decoders[i]->empty_net_dec_in(empty_net_dec_in[i]);

	    encoder_decoders[i]->av_dec_ip_out(av_dec_ip_out[i]);
	    encoder_decoders[i]->data_dec_ip_out(data_dec_ip_out[i]);
	    encoder_decoders[i]->empty_dec_ip_out(empty_dec_ip_out[i]);
	    encoder_decoders[i]->re_ip_dec_in(re_ip_dec_in[i]);
	 }
      }

      ~enc_dec_1d()
      {
	 for(unsigned int i = 0; i < n_ag_g; ++i)
	 {
	    if(encoder_decoders[i])
	    {
	       delete encoder_decoders[i];
	       encoder_decoders[i] = 0;
	    }
	 }
      }

   private:
      
      packet_encoder_decoder<wait_empty_fifo_g,
			     data_width_g,
			     addr_width_g,
			     tx_len_width_g,
			     packet_length_g,
			     timeout_g,
			     fill_packet_g,
			     lut_en_g,
			     net_type_g,
			     len_flit_en_g,
			     oaddr_flit_en_g,
			     status_en_g>* encoder_decoders[n_ag_g];

   };

}
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
