/**
 *
 * @file addr_lut_pkg.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: addr_lut_pkg.hh 1399 2010-08-26 13:56:45Z lehton87 $
 */


#ifndef ASEBT_SC_RTL_1_ADDR_LUT_PKG_HH
#define ASEBT_SC_RTL_1_ADDR_LUT_PKG_HH

#include <systemc>

namespace asebt
{
namespace sc_rtl_1
{
   namespace {      
      const unsigned int n_net_types_c = 4;
      const unsigned int addr_w_c      = 36;
      const unsigned int out_addr_w_c  = 36;
   }
   
   struct addr_rec
   {
      sc_dt::sc_lv<addr_w_c> in_addr;
      sc_dt::sc_lv<addr_w_c> mask;
   };

   const unsigned int n_addr_ranges_c = 17;

   typedef addr_rec address_array[n_addr_ranges_c];

   struct number_record
   {
      int x;
      int y;
      int z;
   };

   typedef number_record number_array[n_net_types_c][n_addr_ranges_c];

   typedef sc_dt::sc_lv<out_addr_w_c> res_addr_array[n_addr_ranges_c];

/*void gen_result_adresses(res_addr_array ret_val,
  number_array numb_arr, 
  unsigned int net_type);

  number_record get_num(sc_core::sc_lv<addr_w_c> addr, unsigned int net_type);
*/
   const address_array addr_table_c =
   {
      {0x00b000100, 0x0ffffff00},
      {0x00b000300, 0x0ffffff00},
      {0x00b000500, 0x0ffffff00},
      {0x00b000700, 0x0ffffff00},
      {0x00b000900, 0x0ffffff00},
      {0x00b000b00, 0x0ffffff00},
      {0x00b000d00, 0x0ffffff00},
      {0x00b000f00, 0x0ffffff00},
      {0x00b001100, 0x0ffffff00},
      {0x00b001300, 0x0ffffff00},
      {0x00bfffe00, 0x0fffffe00},
      {"100001001000000000000000000000000" /*0x109000000,*/, 
       "111111111000000000000000000000000" /*0x1ff000000}*/},
      {0x009000000, 
       "111111111000000000000000000000000" /*0x1ff000000}*/},
      {0x00bfedd00, 0x0ffffff00},
      {0x00bfedf00, 0x0ffffff00},
      {0x00bfefd00, 0x0ffffff00},
      {0x00bfeff00, 0x0ffffff00}
   };

   const number_array num_table_c =
   {
      {                                 // HIBI {useless, reserved}
	 {0, -1, -1},                     //MASTER     
	 {1, -1, -1},                     //Slave1
	 {2, -1, -1},                     //Slave2
	 {3, -1, -1},                     //Slave3
	 {4, -1, -1},                     //Slave4
	 {5, -1, -1},                     //Slave5
	 {6, -1, -1},                     //Slave6
	 {7, -1, -1},                     //Slave7
	 {8, -1, -1},                     //Slave8
	 {9, -1, -1},                     //Slave9
	 {10, -1, -1},                     //SDRAM_msg
	 {11, -1, -1},                     //SDRAM_data
	 {12, -1, -1},                     //RTM
	 {13, -1, -1},                     //ME 2
	 {14, -1, -1},                     //ME 1
	 {15, -1, -1},                     //dctQidct 2
	 {16, -1, -1}                      //dctQidct 1      
      },
      {                                 // MESH:      
	 {0, 0, -1},                     //MASTER     
	 {1, 0, -1},                     //Slave1
	 {2, 0, -1},                     //Slave2
	 {3, 0, -1},                     //Slave3
	 {0, 1, -1},                     //Slave4
	 {1, 1, -1},                     //Slave5
	 {2, 1, -1},                     //Slave6
	 {3, 1, -1},                     //Slave7
	 {0, 2, -1},                     //Slave8
	 {1, 2, -1},                     //Slave9
	 {2, 2, -1},                     //SDRAM_msg
	 {3, 2, -1},                     //SDRAM_data
	 {0, 3, -1},                     //RTM
	 {1, 3, -1},                     //ME 2
	 {2, 3, -1},                     //ME 1
	 {3, 3, -1},                     //dctQidct 2
	 {0, 4, -1}                      //dctQidct 1      
      },
      {                                 // Octagon:
	 {0, 0, 0},                      //MASTER     
	 {0, 0, 0},                      //Slave1
	 {0, 0, 0},                      //Slave2
	 {0, 0, 0},                      //Slave3
	 {0, 0, 0},                      //Slave4
	 {0, 0, 0},                      //Slave5
	 {0, 0, 0},                      //Slave6
	 {0, 0, 0},                      //Slave7
	 {0, 0, 0},                      //Slave8
	 {0, 0, 0},                      //Slave9
	 {0, 0, 0},                      //RTM
	 {0, 0, 0},                      //SDRAM_msg
	 {0, 0, 0},                      //SDRAM_data
	 {0, 0, 0},                      //ME 2
	 {0, 0, 0},                      //ME 1
	 {0, 0, 0},                      //dctQidct 2
	 {0, 0, 0}                       //dctQidct 1 
      },
      {                                 // Crossbar:
	 {0, 0, 0},                      //MASTER     
	 {0, 0, 1},                      //Slave1
	 {0, 0, 2},                      //Slave2
	 {0, 0, 3},                      //Slave3
	 {0, 0, 4},                      //Slave4
	 {0, 0, 5},                      //Slave5
	 {0, 0, 6},                      //Slave6
	 {0, 0, 7},                      //Slave7
	 {0, 0, 8},                      //Slave8
	 {0, 0, 9},                      //Slave9
	 {0, 0, 10},                     //RTM
	 {0, 0, 11},                     //SDRAM_msg
	 {0, 0, 12},                     //SDRAM_data
	 {0, 0, 13},                     //ME 2
	 {0, 0, 14},                     //ME 1
	 {0, 0, 15},                     //dctQidct 2
	 {0, 0, 16}                      //dctQidct 1 
      }
   };


}
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
