/**
 *
 * @file tlm_1_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: tlm_1_factory.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#include "tlm_1_factory.hh"

#include <string>
#include <iostream>
#include <stdexcept>

namespace asebt
{
   namespace mesh_2d_sc_tlm_1
   {
      
      Tlm1Factory::Tlm1Factory(sctg::NocConfIf* nocConfIf)
      :
	 _tlmMesh_2x2(0),
	 _adapter_4(0),
	 _tlmMesh_3x3(0),
	 _adapter_9(0),
	 _tlmMesh_4x4(0),
	 _adapter_16(0),
	 _tlmMesh_5x5(0),
	 _adapter_25(0),
	 _tlmMesh_6x6(0),
	 _adapter_36(0),
	 _tlmMesh_8x8(0),
	 _adapter_64(0)
      {  
	 std::string subtype = nocConfIf->getNocSubType();
	 
	 if(subtype == "2x2")
	 {
	    _adapter_4 = new sctg::SctgToOsciTlm<4, 32>("adapter", nocConfIf);
	    _tlmMesh_2x2 = new TlmMesh2D<32, 2, 2>("mesh_2d");
	    for(unsigned int i = 0; i < 4; ++i)
	    {	    
	       _adapter_4->initSockets[i].bind(_tlmMesh_2x2->targetSockets[i]);
	       _tlmMesh_2x2->initSockets[i].bind(_adapter_4->targetSockets[i]);
	    }
	 }
	 else if(subtype == "3x3")
	 {
	    _adapter_9 = new sctg::SctgToOsciTlm<9, 32>("adapter", nocConfIf);
	    _tlmMesh_3x3 = new TlmMesh2D<32, 3, 3>("mesh_2d");
	    for(unsigned int i = 0; i < 9; ++i)
	    {	    
	       _adapter_9->initSockets[i].bind(_tlmMesh_3x3->targetSockets[i]);
	       _tlmMesh_3x3->initSockets[i].bind(_adapter_9->targetSockets[i]);
	    }
	 }
	 else if(subtype == "4x4")
	 {
	    _adapter_16 = new sctg::SctgToOsciTlm<16, 32>("adapter", nocConfIf);
	    _tlmMesh_4x4 = new TlmMesh2D<32, 4, 4>("mesh_2d");
	    for(unsigned int i = 0; i < 16; ++i)
	    {	    
	       _adapter_16->initSockets[i].bind(_tlmMesh_4x4->targetSockets[i]);
	       _tlmMesh_4x4->initSockets[i].bind(_adapter_16->targetSockets[i]);
	    }
	 }
	 else if(subtype == "5x5")
	 {
	    _adapter_25 = new sctg::SctgToOsciTlm<25, 32>("adapter", nocConfIf);
	    _tlmMesh_5x5 = new TlmMesh2D<32, 5, 5>("mesh_2d");
	    for(unsigned int i = 0; i < 25; ++i)
	    {	    
	       _adapter_25->initSockets[i].bind(_tlmMesh_5x5->targetSockets[i]);
	       _tlmMesh_5x5->initSockets[i].bind(_adapter_25->targetSockets[i]);
	    }
	 }
	 else if(subtype == "6x6")
	 {
	    _adapter_36 = new sctg::SctgToOsciTlm<36, 32>("adapter", nocConfIf);
	    _tlmMesh_6x6 = new TlmMesh2D<32, 6, 6>("mesh_2d");
	    for(unsigned int i = 0; i < 36; ++i)
	    {	    
	       _adapter_36->initSockets[i].bind(_tlmMesh_6x6->targetSockets[i]);
	       _tlmMesh_6x6->initSockets[i].bind(_adapter_36->targetSockets[i]);
	    }
	 }
	 else if(subtype == "8x8")
	 {
	    _adapter_64 = new sctg::SctgToOsciTlm<64, 32>("adapter", nocConfIf);
	    _tlmMesh_8x8 = new TlmMesh2D<32, 8, 8>("mesh_2d");
	    for(unsigned int i = 0; i < 64; ++i)
	    {	    
	       _adapter_64->initSockets[i].bind(_tlmMesh_8x8->targetSockets[i]);
	       _tlmMesh_8x8->initSockets[i].bind(_adapter_64->targetSockets[i]);
	    }
	 }
	 else
	 {
	    std::ostringstream oss;
	    oss << "Tlm1Factory unknown subtype :\"" << subtype << "\"";
	    throw std::runtime_error(oss.str().c_str());
	 }

      }
      
      Tlm1Factory::~Tlm1Factory()
      {
	 if(_tlmMesh_2x2) {delete _tlmMesh_2x2; _tlmMesh_2x2 = 0;}
	 if(_adapter_4)   {delete _adapter_4; _adapter_4 = 0;}
	 if(_tlmMesh_3x3) {delete _tlmMesh_3x3; _tlmMesh_3x3 = 0;}
	 if(_adapter_9)   {delete _adapter_9; _adapter_9 = 0;}
	 if(_tlmMesh_4x4) {delete _tlmMesh_4x4; _tlmMesh_4x4 = 0;}
	 if(_adapter_16)  {delete _adapter_16; _adapter_16 = 0;}
	 if(_tlmMesh_5x5) {delete _tlmMesh_5x5; _tlmMesh_5x5 = 0;}
	 if(_adapter_25)  {delete _adapter_25; _adapter_25 = 0;}
	 if(_tlmMesh_6x6) {delete _tlmMesh_6x6; _tlmMesh_6x6 = 0;}
	 if(_adapter_36)  {delete _adapter_36; _adapter_36 = 0;}
	 if(_tlmMesh_8x8) {delete _tlmMesh_8x8; _tlmMesh_8x8 = 0;}
	 if(_adapter_64)  {delete _adapter_64; _adapter_64 = 0;}
      }           
   }
}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

