/**
 *
 * @file mesh_2d.hh
 * @author Lasse Lehtonen
 *
 * 
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: mesh_2d.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#ifndef ASEBT_MESH_2D_SC_2_MESH_2D_HH
#define ASEBT_MESH_2D_SC_2_MESH_2D_HH

#include "mesh_router.hh"

#include <systemc>
using sc_core::sc_signal;
using sc_dt::sc_bv;

#include <sstream>

namespace asebt
{
namespace mesh_2d_sc_2
{

   template <int fifo_depth_g, 
	     int pkt_len_g, 
	     int stfwd_en_g = 1, 
	     int data_width_g = 16, 
	     int addr_width_g = 16, 
	     int len_flit_en_g = 1, 
	     int oaddr_flit_en_g = 1, 
	     int mesh_freq_g = 1, 
	     int ip_freq_g = 1, 
	     int rows_g = 4, 
	     int cols_g = 4>
   class mesh_2d : public sc_core::sc_module
   {
   public:
      sc_core::sc_in<bool>              rst_n;
      sc_core::sc_in_clk                    clk_mesh;
      sc_core::sc_in_clk                    clk_ip;

      sc_core::sc_in<sc_bv<data_width_g> >  tx_data_in[rows_g][cols_g];
      sc_core::sc_in<bool>              tx_we_in[rows_g][cols_g];
      sc_core::sc_in<bool>              rx_re_in[rows_g][cols_g];
      sc_core::sc_out<sc_bv<data_width_g> > rx_data_out[rows_g][cols_g];
      sc_core::sc_out<bool>             rx_empty_out[rows_g][cols_g];
      sc_core::sc_out<bool>             rx_full_out[rows_g][cols_g];
      sc_core::sc_out<bool>             tx_full_out[rows_g][cols_g];
      sc_core::sc_out<bool>             tx_empty_out[rows_g][cols_g];

      //SC_HAS_PROCESS(mesh_2d);
  
      mesh_2d(sc_core::sc_module_name name)
	 : sc_core::sc_module(name),
	   rst_n("rst_n"),
	   clk_mesh("clk_mesh"),
	   clk_ip("clk_ip")
	   /*,
	     tx_data_in("tx_data_in"),
	     tx_we_in("tx_we_in"),
	     rx_re_in("rx_re_in"),
	     rx_data_out("rx_data_out"),
	     rx_empty_out("rx_empty_out"),
	     rx_full_out("rx_full_out"),
	     tx_full_out("tx_full_out"),
	     tx_empty_out("tx_empty_out")*/
      {
	 for(unsigned int r = 0; r < rows_g; ++r)
	 {
	    for(unsigned int c = 0; c < cols_g; ++c)
	    {
	       // Create name for router
	       std::ostringstream oss;
	       oss << "router_" << r << "_" << c;

	       // Create new router
	       mesh_router<stfwd_en_g, 
		  data_width_g,
		  addr_width_g,
		  fifo_depth_g,
		  pkt_len_g,
		  len_flit_en_g,
		  oaddr_flit_en_g,
		  ip_freq_g,
		  mesh_freq_g,	 
		  cols_g,
		  rows_g>* router = new
		  mesh_router<stfwd_en_g, 
		  data_width_g,
		  addr_width_g,
		  fifo_depth_g,
		  pkt_len_g,
		  len_flit_en_g,
		  oaddr_flit_en_g,
		  ip_freq_g,
		  mesh_freq_g,	 
		  cols_g,
		  rows_g>
		  (oss.str().c_str(), c, r);

	       // Store its pointer
	       mesh_routers[r*(cols_g)+c] = router;

	       // bind ports
	       router->rst_n(rst_n);
	       router->clk_mesh(clk_mesh);
	       router->clk_ip(clk_ip);

	       router->data_in[N](mesh_data_n_s[r][c]);
	       router->empty_in[N](mesh_empty_n_s[r][c]);
	       router->full_in[N](mesh_full_n_s[r][c]);
	       router->re_in[N](mesh_re_n_s[r][c]);

	       router->data_in[S](mesh_data_s_n[r+1][c]);
	       router->empty_in[S](mesh_empty_s_n[r+1][c]);
	       router->full_in[S](mesh_full_s_n[r+1][c]);
	       router->re_in[S](mesh_re_s_n[r+1][c]);
	    
	       router->data_in[W](mesh_data_w_e[r][c]);
	       router->empty_in[W](mesh_empty_w_e[r][c]);
	       router->full_in[W](mesh_full_w_e[r][c]);
	       router->re_in[W](mesh_re_w_e[r][c]);

	       router->data_in[E](mesh_data_e_w[r][c+1]);
	       router->empty_in[E](mesh_empty_e_w[r][c+1]);
	       router->full_in[E](mesh_full_e_w[r][c+1]);
	       router->re_in[E](mesh_re_e_w[r][c+1]);

	       router->data_ip_tx_in(tx_data_in[r][c]);
	       router->we_ip_tx_in(tx_we_in[r][c]);
	       router->re_ip_rx_in(rx_re_in[r][c]);

	       router->data_out[N](mesh_data_s_n[r][c]);
	       router->empty_out[N](mesh_empty_s_n[r][c]);
	       router->full_out[N](mesh_full_s_n[r][c]);
	       router->re_out[N](mesh_re_s_n[r][c]);

	       router->data_out[S](mesh_data_n_s[r+1][c]);
	       router->empty_out[S](mesh_empty_n_s[r+1][c]);
	       router->full_out[S](mesh_full_n_s[r+1][c]);
	       router->re_out[S](mesh_re_n_s[r+1][c]);

	       router->data_out[W](mesh_data_e_w[r][c]);
	       router->empty_out[W](mesh_empty_e_w[r][c]);
	       router->full_out[W](mesh_full_e_w[r][c]);
	       router->re_out[W](mesh_re_e_w[r][c]);

	       router->data_out[E](mesh_data_w_e[r][c+1]);
	       router->empty_out[E](mesh_empty_w_e[r][c+1]);
	       router->full_out[E](mesh_full_w_e[r][c+1]);
	       router->re_out[E](mesh_re_w_e[r][c+1]);

	       router->data_ip_rx_out(rx_data_out[r][c]);
	       router->empty_ip_rx_out(rx_empty_out[r][c]);
	       router->full_ip_rx_out(rx_full_out[r][c]);
	       router->empty_ip_tx_out(tx_empty_out[r][c]);
	       router->full_ip_tx_out(tx_full_out[r][c]);	      
	    }
	 }

	 for(unsigned int c = 0; c < cols_g; ++c)
	 {
	    mesh_data_n_s[0][c].write("0");
	    mesh_empty_n_s[0][c].write(true);
	    mesh_full_n_s[0][c].write(false);
	    mesh_re_n_s[0][c].write(false);

	    mesh_data_s_n[rows_g][c].write("0");
	    mesh_empty_s_n[rows_g][c].write(true);
	    mesh_full_s_n[rows_g][c].write(false);
	    mesh_re_s_n[rows_g][c].write(false);
	 }

	 for(unsigned int r = 0; r < rows_g; ++r)
	 {
	    mesh_data_w_e[r][0].write("0");
	    mesh_empty_w_e[r][0].write(true);
	    mesh_full_w_e[r][0].write(false);
	    mesh_re_w_e[r][0].write(false);

	    mesh_data_e_w[r][cols_g].write("0");
	    mesh_empty_e_w[r][cols_g].write(true);
	    mesh_full_e_w[r][cols_g].write(false);
	    mesh_re_e_w[r][cols_g].write(false);
	 }
      }
  
      virtual ~mesh_2d()
      {
	 for(unsigned int r = 0; r < rows_g; ++r)
	 {
	    for(unsigned int c = 0; c < cols_g; ++c)
	    {
	       delete mesh_routers[r*(cols_g)+c];
	       mesh_routers[r*(cols_g)+c] = 0;
	    }
	 }
      }
  
   private:

      mesh_router<stfwd_en_g, 
		  data_width_g,
		  addr_width_g,
		  fifo_depth_g,
		  pkt_len_g,
		  len_flit_en_g,
		  oaddr_flit_en_g,
		  ip_freq_g,
		  mesh_freq_g,	 
		  cols_g,
		  rows_g>* mesh_routers[rows_g*cols_g];  

      sc_signal<sc_bv<data_width_g> > mesh_data_s_n[rows_g+1][cols_g];
      sc_signal<bool>             mesh_re_s_n[rows_g+1][cols_g];
      sc_signal<bool>             mesh_empty_s_n[rows_g+1][cols_g];
      sc_signal<bool>             mesh_full_s_n[rows_g+1][cols_g];

      sc_signal<sc_bv<data_width_g> > mesh_data_n_s[rows_g+1][cols_g];
      sc_signal<bool>             mesh_re_n_s[rows_g+1][cols_g];
      sc_signal<bool>             mesh_empty_n_s[rows_g+1][cols_g];
      sc_signal<bool>             mesh_full_n_s[rows_g+1][cols_g];

      sc_signal<sc_bv<data_width_g> > mesh_data_e_w[rows_g][cols_g+1];
      sc_signal<bool>             mesh_re_e_w[rows_g][cols_g+1];
      sc_signal<bool>             mesh_empty_e_w[rows_g][cols_g+1];
      sc_signal<bool>             mesh_full_e_w[rows_g][cols_g+1];

      sc_signal<sc_bv<data_width_g> > mesh_data_w_e[rows_g][cols_g+1];
      sc_signal<bool>             mesh_re_w_e[rows_g][cols_g+1];
      sc_signal<bool>             mesh_empty_w_e[rows_g][cols_g+1];
      sc_signal<bool>             mesh_full_w_e[rows_g][cols_g+1];

  
  

   };

}
}


#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
