/**
 *
 * @file mesh_factory.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: mesh_factory.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef MESH_2D_NOC_FACTORY_HH
#define MESH_2D_NOC_FACTORY_HH

#include "sc_rtl_1/noc_factory.hh"
#include "sc_rtl_2/noc_factory.hh"
#include "sc_tlm_1/tlm_1_factory.hh"

#ifdef SCTG_USE_OCPTLM
#include "sc_ocp_tl3_1/ocp_tl3_factory.hh"
#endif

// Using VHDL NoCs only when mixed language simulation is enabled
#ifdef SCTG_MIXED_LANGUAGE_SIM
#include "vhd/noc_factory.hh"
#endif

#include "noc_conf_if.hh"

#include <systemc>

namespace asebt
{
   
   class MeshFactory
   {
   public:
      
      MeshFactory(sctg::NocConfIf* nocConfIf);
      
      virtual ~MeshFactory();      
      
   private:   
      
      asebt::mesh_2d_sc_1::NocFactory* _mesh_2d_sc_1;
      asebt::mesh_2d_sc_2::NocFactory* _mesh_2d_sc_2;
      asebt::mesh_2d_sc_tlm_1::Tlm1Factory* _mesh_2d_sc_tlm_1;

#ifdef SCTG_USE_OCPTLM
      sctg::mesh_2d_sc_ocp_tl3_1::OcpTl3Factory* _mesh_2d_sc_ocp_tl3_1;
#endif

      
// Using VHDL NoCs only when mixed language simulation is enabled
#ifdef SCTG_MIXED_LANGUAGE_SIM
      asebt::mesh_2d_vhd::NocFactory* _mesh_2d_vhd;
#endif
      
      MeshFactory(const MeshFactory&);
      MeshFactory& operator=(const MeshFactory&);
   };
   
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
