/*
 * Created on 20.7.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.ui.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import java.net.URISyntaxException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.xml.sax.InputSource;

import fi.cpu.xml.bind.uiconfig.ObjectFactory;
import fi.cpu.xml.bind.uiconfig.UIConfigType;

/**
 * @author Timo Vanhatupa
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class UIConfigMarshaller {

	public UIConfigType loadUIConfig(String configFile)
			throws FileNotFoundException, JAXBException {
		UIConfigType uiconfig = null;
		JAXBContext jc = JAXBContext.newInstance("fi.cpu.xml.bind.uiconfig",
				this.getClass().getClassLoader());
		Unmarshaller u = jc.createUnmarshaller();
		u.setValidating(true);
		uiconfig = (UIConfigType) u.unmarshal(new InputSource(new FileReader(
				configFile)));
		return uiconfig;

	}

	public void saveUIConfig(String configFile, UIConfigType uiConfig)
			throws JAXBException, IOException {
		JAXBContext jc = JAXBContext.newInstance("fi.cpu.xml.bind.uiconfig",
				this.getClass().getClassLoader());
		Marshaller u = jc.createMarshaller();
		u.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		
		FileWriter writer = new FileWriter(configFile);
		
		u.marshal(uiConfig, writer);
		writer.close();
	}

	public ObjectFactory getObjectFactory() {
		ObjectFactory of = new ObjectFactory();
		return of;
	}
}