/*
 * CVS-tietoja:
 * $Author: perttul5 $ 
 * $Date: 2008-04-22 11:18:51 +0300 (ti, 22 huhti 2008) $ 
 * $Revision: 3467 $
 *
 * Created on 19.7.2005
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *
 */
package fi.cpu.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import fi.cpu.data.Chart;
import fi.cpu.ui.graph.GraphPanel;
import fi.cpu.ui.xml.UIConfigIO;


/**
 * @author jsikio
 *
 */
public class MenuItemListener implements ActionListener
{

    private static boolean saveOK = false;
    private static String filename = "";
    
    private JFileChooser fileChooser_ = new JFileChooser();
    
    /* (non-Javadoc)
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed( ActionEvent e )
    {
        JMenuItem source = (JMenuItem)e.getSource();
        
        if( source.getName().equalsIgnoreCase( MainWindow.EXIT_NAME ) )
        {
            MainWindow.getInstance().dispose();
        }
        else if( source.getName().equalsIgnoreCase( MainWindow.OPEN_NAME ) )
        {
            int rValue = fileChooser_.showOpenDialog( MainWindow.getInstance() );
            
            if( rValue == JFileChooser.APPROVE_OPTION )
            {                
                filename = fileChooser_.getSelectedFile().getAbsolutePath();

                UIConfigIO.readConfiguration(MainWindow.getInstance().getConfiguration(),
                		MainWindow.getInstance(), filename);
                
                saveOK = true;
            }
        }
        else if( source.getName().equalsIgnoreCase( MainWindow.SAVE_NAME ) )
        {
            if( saveOK )
            {
                //Voidaan suoraan tallentaa
            	UIConfigIO.writeConfiguration(MainWindow.getInstance().getConfiguration(),
                		MainWindow.getInstance(), filename);
            }
            else
            {
                //Selvitetn minne tallennetaan
                int rValue = fileChooser_.showSaveDialog( MainWindow.getInstance() );
                
                if( rValue == JFileChooser.APPROVE_OPTION )
                {                  
                    filename = fileChooser_.getSelectedFile().getAbsolutePath();

                	UIConfigIO.writeConfiguration(MainWindow.getInstance().getConfiguration(),
                    		MainWindow.getInstance(), filename);
                    
                    saveOK = true;
                }  
            }

        }
        else if( source.getName().equalsIgnoreCase( MainWindow.EDIT_SETTINGS_NAME ) )
        {
            SettingsDialog.getInstance().setVisible(true);            
        }
        else if( source.getName().equalsIgnoreCase( MainWindow.SAVE_AS_NAME ) )
        {
            int rValue = fileChooser_.showSaveDialog( MainWindow.getInstance() );
            
            if( rValue == JFileChooser.APPROVE_OPTION )
            {
                filename = fileChooser_.getSelectedFile().getAbsolutePath();

            	UIConfigIO.writeConfiguration(MainWindow.getInstance().getConfiguration(),
                		MainWindow.getInstance(), filename);
                
                saveOK = true;
            }
        }
        else if( source.getName().equalsIgnoreCase( MainWindow.CONNECTION ) )
        {
            JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)source;
            if(  checkBox.isSelected() )
            {
                MainWindow.getInstance().getConnectionHandler().reconnect();
            }
            else
            {
                MainWindow.getInstance().getConnectionHandler().disconnect();
            }
        }
        else if( source.getName().equalsIgnoreCase( MainWindow.SHOW_DEBUG_WINDOW ) )
        {
            MainWindow.getInstance().showDebugWindow(0, 0, 200, 300);
        }
        else if( source.getName().equalsIgnoreCase( MainWindow.ADD_GRAPH ) )
        {
        	ChartCreationDialog.getInstance().setCPUspecifig(false);
			Chart chart = ChartCreationDialog.getInstance().showDialog();
			if (chart != null) {
				GraphPanel panel = new GraphPanel();
				panel.setChart(chart);
				MainWindow.getInstance().addChart(panel, 10, 10, 200, 300);
			}
        }
        else if( source.getName().equalsIgnoreCase( MainWindow.ABOUT_NAME ) )
        {
            String versio = MainWindow.VERSION;
            String appName = MainWindow.bundle.getString("MAINTITLE");
            StringBuilder msg = new StringBuilder(appName);
            msg.append(" Version ");
            msg.append(versio);
            msg.append("\n(c) 2005 - 2007 DCS/TUT\nJanne Siki & Timo Vanhatupa Version 1.0");
            msg.append("\nTomi Jntti Version 1.1 - 1.3");
            msg.append("\nKalle Lappalainen Version 1.4");
            
            JOptionPane.showMessageDialog(MainWindow.getInstance(),
            		msg.toString(), "Authors", JOptionPane.INFORMATION_MESSAGE );
        }
    }

}
