// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stephane Guntz, PROSILOG, guntz@prosilog.com
//                Herve Alexanian, Sonics, inc herve@sonicsinc.com
//
//  Description : 
//  testbench for tl2-tl1 slave adapter example
//  $Id: top_tl1_tl2_slave_adapter.cpp,v 1.4 2007/01/25 22:22:39 halexan Exp $
//
//  The master reads its stimulus from stl files
//
// The TL1-TL2 slave adapter separates the first burst into consecutive TL1 write requests 
// The TL1 responses are sent to the master as chunks (size=5, which is the maximum chunk length).
//
// 
// ============================================================================

#include "systemc.h"
#include "MasterTL2.h"
#include "ocp_tl1_slave_sync.h"
#include "ocp_tl1_tl2_slave_adapter.h"
#include "ocp_tl1_channel.h"
#include "ocp_tl1_trace_monitor.h"
#include "ocp_tl2_channel.h"

bool g_debug = true;

void readMapFromFile(const string &myFileName, MapStringType &myParamMap) 
{
    // read pairs of data from the passed file
    string leftside;
    string rightside;
    
    // (1) open the file
    ifstream inputfile(myFileName.c_str());
    assert( inputfile );

    // set the formatting
    inputfile.setf(std::ios::skipws);

    // Now read through all the pairs of values and add them to the passed map
    while ( inputfile ) {
        inputfile >> leftside;
        inputfile >> rightside;
        myParamMap.insert(std::make_pair(leftside,rightside));
    }

    // All done, close up
    inputfile.close();
}



int sc_main(int argc, char* argv[])
{
    typedef unsigned int Td;
    typedef unsigned int Ta;

    sc_clock clk("clock", 1, SC_NS, 0.5, 0, SC_NS, true);

    //TL1 and TL2 channels instantiation 
    OCP_TL1_Channel<OCP_TL1_DataCl<Td, Ta> > channel0( "channel0", &clk );
    OCP_TL2_Channel< Td, Ta > channel1("channel1");
    //TL1 monitor
    OCP_TL1_Trace_Monitor<OCP_TL1_DataCl<Td, Ta> > monitor( "ocp", "ocp.ocp" );

    // Set the OCP parameters for this channel
    MapStringType  ocpParamMap;
    readMapFromFile("ocpParams_slave_adapter_tl1_tl2", ocpParamMap);
    channel1.setConfiguration(ocpParamMap);
    channel0.setConfiguration(ocpParamMap);

    //TL2 master and TL1 slave instantiation
    OcpIp::MasterTL2<Td, Ta> master1("master1"); 
    OCP_TL1_Slave_Sync<OCP_TL1_DataCl<Td, Ta> > slave1("slave1", 2, 0, 0xff);

    //adapter instantiation
    //chunk length=5, maximum burst length=25, adapter depth= 6
    OCP_TL1_TL2_Slave_Adapter<OCP_TL1_DataCl<Td, Ta> >slave_adapter("slave_adapter", 5, 25, 6);

    //binding
    master1.m_config.req2data_latency = 2;
    master1.ipP(channel1);

    slave_adapter.MasterP(channel0);
    slave_adapter.SlaveP(channel1);
    slave_adapter.clk(clk);

    slave1.SlaveP(channel0);
    slave1.clk(clk);

    monitor.p_clk(clk);
    monitor.p_mon( channel0 );

    sc_start(1000, SC_NS);


    return 0;
}
