// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia, Inc.,
//		  Tim Kogel, CoWare, Inc
//          $Id:
//
//  Description : OCP TL3 Slave Interface declaration
//
// ============================================================================

#ifndef _OCP_TL3_SLAVE_IF
#define _OCP_TL3_SLAVE_IF

#include "systemc.h"

template <typename REQ>
class OCP_TL3_SlaveRequestIF : 
  virtual public sc_interface
{
  public:
  // Message access
  virtual bool getRequest(REQ& req) = 0;
  virtual bool getRequestBlocking(REQ& req) = 0;
  
  virtual bool acceptRequest(void) = 0;
  virtual bool acceptRequest(const sc_time& time) = 0;
  virtual bool acceptRequest(const int cycles) = 0;

  virtual bool requestInProgress(void) const = 0;

  // Event access
  virtual const sc_event& RequestStartEvent(void) const = 0; 
  virtual const sc_event& RequestEndEvent(void) const = 0; 
};

template <typename RESP>
class OCP_TL3_SlaveResponseIF : 
  virtual public sc_interface
{
  public:
  virtual bool sendResponse(const RESP& resp) = 0;
  virtual bool sendResponse(const RESP& req, const sc_time& time) = 0;
  virtual bool sendResponse(const RESP& req, const int cycles) = 0;

  virtual bool sendResponseBlocking(const RESP& resp) = 0;

  virtual bool responseInProgress(void) const = 0;
    
  // Event access
  virtual const sc_event& ResponseStartEvent(void) const = 0;
  virtual const sc_event& ResponseEndEvent(void) const = 0;
};

//----------------------------------------------------------------------
// composition interfaces
//----------------------------------------------------------------------
template <typename REQ,typename RESP>
class OCP_TL3_SlaveIF :  
  public OCP_TL3_SlaveRequestIF<REQ>,
  public OCP_TL3_SlaveResponseIF<RESP> 
{};

#endif // _TLM_TL3_SLAVE_IF

