///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2004 OCP-IP
// OCP-IP Confidential & Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//          Date: 01/06/2005
//
//  Description :  OCP Channel Transaction Recording Monitor
//	  This channel monitor is based on the transaction recording 
//	  API in the SystemC Verification (SCV) Library. It targets 
//	  performance analysis for architectural modeling.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _OCP_PERF_MONITOR_EXTENSIONS_H
#define _OCP_PERF_MONITOR_EXTENSIONS_H

#include "scv.h"
#include "ocp_globals.h"

// MCmd encoding
template<>
class scv_extensions<OCPMCmdType> : public scv_enum_base<OCPMCmdType> {
public:

  SCV_ENUM_CTOR(OCPMCmdType) {
    SCV_ENUM(OCP_MCMD_IDLE);
    SCV_ENUM(OCP_MCMD_WR);
    SCV_ENUM(OCP_MCMD_RD);
    SCV_ENUM(OCP_MCMD_RDEX);
    SCV_ENUM(OCP_MCMD_RDL);
    SCV_ENUM(OCP_MCMD_WRNP);
    SCV_ENUM(OCP_MCMD_WRC);
    SCV_ENUM(OCP_MCMD_BCST);
  }
};

// SResp encoding
template<>
class scv_extensions<OCPSRespType> : public scv_enum_base<OCPSRespType> {
public:

  SCV_ENUM_CTOR(OCPSRespType) {
    SCV_ENUM(OCP_SRESP_NULL);
    SCV_ENUM(OCP_SRESP_DVA);
    SCV_ENUM(OCP_SRESP_FAIL);
    SCV_ENUM(OCP_SRESP_ERR);
  }
};

// MBurstSeq encoding
template<>
class scv_extensions<OCPMBurstSeqType> : public scv_enum_base<OCPMBurstSeqType> {
public:

  SCV_ENUM_CTOR(OCPMBurstSeqType) {
    SCV_ENUM(OCP_MBURSTSEQ_INCR);
    SCV_ENUM(OCP_MBURSTSEQ_DFLT1);
    SCV_ENUM(OCP_MBURSTSEQ_WRAP);
    SCV_ENUM(OCP_MBURSTSEQ_DFLT2);
    SCV_ENUM(OCP_MBURSTSEQ_XOR);
    SCV_ENUM(OCP_MBURSTSEQ_STRM);
    SCV_ENUM(OCP_MBURSTSEQ_UNKN);
    SCV_ENUM(OCP_MBURSTSEQ_RESERVED);
  }
};


////////////////////////////////////////////////////
// TL2 RequestGrp holds the OCP request information 
////////////////////////////////////////////////////
template<class Td, class Ta>
class scv_extensions<OCPTL2RequestGrp<Td,Ta> > : public scv_extensions_base<OCPTL2RequestGrp<Td,Ta> > {
public:
  // OCP Basics
  scv_extensions<OCPMCmdType> MCmd;
  scv_extensions<Ta> MAddr;
  scv_extensions<Td*> MDataPtr;
  scv_extensions<unsigned int> DataLength;
  
  // OCP Basics +
  scv_extensions<unsigned int> MAddrSpace;
  scv_extensions<unsigned int> MByteEn;
  scv_extensions<unsigned int*> MByteEnPtr;
  scv_extensions<unsigned long long int> MReqInfo;
  scv_extensions<unsigned int> MTagID;
  scv_extensions<unsigned int> MTagInOrder;
  scv_extensions<unsigned long long int> MDataInfo;    
  scv_extensions<unsigned long long int> MDataTagID;    
  scv_extensions<unsigned long long int*> MDataInfoPtr;    

  // OCP Threads
  scv_extensions<unsigned int> MThreadID;
  scv_extensions< unsigned int> MConnID;

  // OCP Burst Information
  scv_extensions< unsigned int> MBurstLength;
  scv_extensions<bool> MBurstPrecise;
  scv_extensions<OCPMBurstSeqType> MBurstSeq;
  
  // Partial Burst Help
  scv_extensions<bool> LastOfBurst;
  // system level transaction recording
  scv_extensions<long long> TrHandle;
  
  
  typedef OCPTL2RequestGrp<Td,Ta> OCPTL2RequestGrp;
  SCV_EXTENSIONS_CTOR(OCPTL2RequestGrp) {
    // below must be in order!
    // OCP Basics
    SCV_FIELD(MCmd);
    SCV_FIELD(MAddr);
    SCV_FIELD(MDataPtr);
    SCV_FIELD( DataLength);

    // OCP Basics +
    SCV_FIELD( MAddrSpace);
    SCV_FIELD(MByteEn);
    SCV_FIELD(MByteEnPtr);
    SCV_FIELD(MReqInfo);
    SCV_FIELD(MTagID);
    SCV_FIELD(MTagInOrder);
    SCV_FIELD(MDataInfo);    
    SCV_FIELD(MDataTagID);    
    SCV_FIELD(MDataInfoPtr);    
    // OCP Threads
    SCV_FIELD(MThreadID);
    SCV_FIELD(MConnID);

    // OCP Burst Information
    SCV_FIELD(MBurstLength);
    SCV_FIELD(MBurstPrecise);
    SCV_FIELD(MBurstSeq);

    // Partial Burst Help
    SCV_FIELD(LastOfBurst);

    // system level transaction recording
    SCV_FIELD(TrHandle);
  }
};

template<class Td>
class scv_extensions<OCPTL2ResponseGrp<Td> > : public scv_extensions_base<OCPTL2ResponseGrp<Td> > {
public:
  // OCP Basics
  scv_extensions<OCPSRespType> SResp;
  scv_extensions<Td*> SDataPtr;
  scv_extensions<unsigned int> DataLength;

  // OCP Basics +
  scv_extensions< unsigned long long int> SDataInfo;
  scv_extensions<unsigned int> STagID;
  scv_extensions<bool> STagInOrder;
  scv_extensions<unsigned long long int> SRespInfo;

  // OCP Threads
  scv_extensions<unsigned int> SThreadID;

  // Partial Burst Support
  scv_extensions<bool> LastOfBurst;

  // system level transaction recording
  scv_extensions<long long> TrHandle;

  typedef OCPTL2ResponseGrp<Td> OCPTL2ResponseGrp;
  SCV_EXTENSIONS_CTOR(OCPTL2ResponseGrp) {
    //must be in order

    // OCP Basics
    SCV_FIELD(SResp);
    SCV_FIELD(SDataPtr);     
    SCV_FIELD(DataLength);

    // OCP Basics +
    SCV_FIELD(SDataInfo);
    SCV_FIELD(STagID);
    SCV_FIELD(STagInOrder);
    SCV_FIELD(SRespInfo);

    // OCP Threads
    SCV_FIELD(SThreadID);

    // Partial Burst Support
    SCV_FIELD(LastOfBurst);

    // system level transaction recording
    SCV_FIELD(TrHandle);
  }
};

#endif
