// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: master_r.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master_r.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master_r::Master_r (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  cnt = 0;
  req.MAddr = 0;
  req.MByteEn = 0xF;
  req.MBurstSingleReq = 0;
  wraplen = 0;
  addr = 0;
  protbits = 0;
  burstcnt = 0;
  SC_METHOD(proc);
  sensitive_pos(clk); 
  dont_initialize();
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master_r::~Master_r() {}

// ----------------------------------------------------------------------------
//  Method : Master_r::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master_r::proc() {
  bool tmp;

  // check if request channel is free
  tmp = !ipP->getSBusy();
  if (tmp) {
    if (cnt<8) {
      wraplen = 0;
      // Set OCP command type
      req.MCmd = OCP_MCMD_RD;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_INCR;
      req.MAddr = addr;
      req.MBurstLength = 8;
      if (burstcnt==7) {
	req.MReqLast = 1; // End of burst
	burstcnt=0;
      }
      else {
	req.MReqLast = 0;
	burstcnt++;
      }	
    }
    else if (cnt<16) {
      wraplen = 8;
      req.MCmd = OCP_MCMD_RD;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_WRAP;
      req.MAddr = addr;
      req.MBurstLength = 8;
      if (burstcnt==7) {
	req.MReqLast = 1; // End of burst
	burstcnt=0;
      }
      else {
	req.MReqLast = 0;
	burstcnt++;
      }
    }
    else if (cnt<24){
      wraplen = 0;
      req.MCmd = OCP_MCMD_RD;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_STRM;
      req.MAddr = 4;
      req.MBurstLength = 8;
      if (burstcnt==7) {
	req.MReqLast = 1; // End of burst
	burstcnt=0;
      }
      else {
	req.MReqLast = 0;
	burstcnt++;
      }
    }
    else if (cnt<28){ // SRMD burst
      wraplen = 0;
      req.MCmd = OCP_MCMD_RD;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_INCR;
      req.MBurstSingleReq = 1;
      req.MAddr = 4;
      req.MBurstLength = 8;
      req.MReqLast = 1; // End of burst
    }
    else {
      req.MCmd = OCP_MCMD_IDLE;
    }

    // Send request
    if (req.MCmd != OCP_MCMD_IDLE)
      tmp = ipP->startOCPRequest(req);
    else
      tmp = 0;

    if (tmp) {

#ifdef DEBUG_G1
      cout << "Master_r sent request "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  MAddr  = " << req.MAddr << endl;
#endif

      // Address generator
      if (wraplen) {
	  if ((addr+4) < ((addr & (~(wraplen-1)*4))+ wraplen*4))
	    addr = addr+4; 
	  else
	    addr = addr & (~((wraplen-1)*4));
      }
      else
	if (addr < 124)
	  addr += 4;
	else
	  addr = 0;
    
      cnt++;
    }
  }

  
  // Check for response
  tmp = ipP->getOCPResponse(resp, true);
  if (tmp) {
    if (resp.SResp == OCP_SRESP_DVA) {

#ifdef DEBUG_G1
      cout << "Master_r got valid response "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  SResp  = " << resp.SResp
	   << "  SData  = " << resp.SData << endl;
#endif

    }
  }
  
} // end of method



