//////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2005 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: ThreadArbiter.h,v 1.1 2007/01/25 21:51:22 halexan Exp $
//
//////////////////////////////////////////////////////////////////////

#ifndef _ThreadArbiter_h_
#define _ThreadArbiter_h_

#include <vector>
#ifndef SYSTEMC_H
#include "systemc.h"
#endif

namespace Sonics {
struct ThreadBusyProxy {
    virtual sc_event_finder& threadBusyEvent() = 0;
    virtual unsigned int     getThreadBusy  () const = 0;
};

class ThreadArbiter : public sc_module {
  public:
    ThreadArbiter( sc_module_name name,
                   ThreadBusyProxy* pThreadBusyProxy = NULL,
                   int numThreads = -1);
    SC_HAS_PROCESS( ThreadArbiter );
    void         setNumThreads( int threads );
    virtual void threadReady( int threadId );
    sc_event&    threadWinner( int threadId ) const;

  protected:
    virtual void end_of_elaboration();
    virtual void arbitrateMethod();

  private:
    int                    m_numThreads;
    int                    m_lastWinner;
    ThreadBusyProxy       *m_pThreadBusyProxy;
    std::vector<sc_event*> m_threadWinner;
    std::vector<int>       m_threadActive;
    sc_event               m_arbitrationTrigger;
};
}

#endif /* _ThreadArbiter_h_ */
