// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: slave.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Slave::Slave (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  address = 0;
  burststart = true;
  resp.SData = 0;
  last_request = OCP_MCMD_IDLE;
  bytemask = 0;
  for (int i=0;i<1024;i++)
    memory[i] = 0;

  SC_METHOD(proc);
  sensitive_pos(clk);
  dont_initialize(); // make sure we execute only at clock edge
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Slave::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc()
//
//  Synchronous slave process
//
// ----------------------------------------------------------------------------

void Slave::proc(){

  // If a previous read has been served, we check for new requests
  if (last_request != OCP_MCMD_RD) {
    is_req = tpP->getOCPRequest(req, true); // accept automatically
    if (is_req) {
      last_request = req.MCmd;
      
      // Byte enable to bitmask
      if (req.MByteEn & 0x1)
	bytemask = 0xFF; 
      if  (req.MByteEn & 0x2)
	bytemask = 0xFF00 | bytemask; 
      if  (req.MByteEn & 0x4)
	bytemask = 0xFF0000 | bytemask; 
      if  (req.MByteEn & 0x8)
	bytemask = 0xFF000000 | bytemask; 

      // Burst addressing
      if (burststart) {
	address = req.MAddr/4; // First of burst
      }
      else {
	if (req.MBurstSeq==OCP_MBURSTSEQ_INCR)
	  address = address+1; //incrementing address
	else if (req.MBurstSeq==OCP_MBURSTSEQ_WRAP) {
	  if ((address+1) < ((address & (~(req.MBurstLength-1)))+ req.MBurstLength)) // wrapping address
	    address = address+1; 
	  else
	    address = address & (~(req.MBurstLength-1));
	}
      }

      if (req.MReqLast==0) // can handle only precise bursts
	burststart = false; // burst continues
      else
	burststart = true; // end of burst, next can start
    }
  }


  // If request was write
  if (last_request == OCP_MCMD_WR ||last_request == OCP_MCMD_WRNP ) {
    if (lock && address==locked_address)
      lock = false; // ReadEx handling is not quite complete here
    memory[address] = req.MData & bytemask;

#ifdef DEBUG_G1
    cout << "Slave got write request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  data  = " << req.MData << endl;
#endif
    last_request = OCP_MCMD_IDLE;

  }
  else if (last_request == OCP_MCMD_RD || last_request == OCP_MCMD_RDEX) {

#ifdef DEBUG_G1
    cout << "Slave got read request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  address  = " << req.MAddr << endl;
#endif

      
    tmp = tpP->getMBusy();
    if (!tmp) {
      // Set OCP response
      if (lock)
	resp.SResp = OCP_SRESP_ERR; // readex must be followed by write
      else
	resp.SResp = OCP_SRESP_DVA;
      resp.SData = memory[address];
      // Send response
      tpP->startOCPResponse(resp);
#ifdef DEBUG_G1
      cout << "Slave sent response " << resp.SResp
	   << " time " << sc_time_stamp().to_seconds()
	   << " data " << resp.SData << endl;
#endif

      // lock address after ReadEx
      if (last_request == OCP_MCMD_RDEX) {
	lock = true;
	locked_address = address;
      }

      last_request = OCP_MCMD_IDLE;
    }
  } // end if (last_request)
} // end of method



