// 
//  Copyright 2003 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Yann Bajot, Prosilog
//         $Id: tl_master_port.h,v 1.3 2004/09/05 17:57:56 halexan Exp $
//
//  Description : Transaction Level Master port declaration.
//                These methods are implemented in the Channel
//                (see tl_channel.h)
//
// ============================================================================


#ifndef TL_MASTER_PORTS_H
#define TL_MASTER_PORTS_H

#include "systemc/communication/sc_event_finder.h"
#include "tl_master_if.h"


template <class TdataCl> class tl_master_port
: public sc_port<TLmasterIF<TdataCl>, 1>
{
    public:

    tl_master_port(const char* name)
        : sc_port<TLmasterIF<TdataCl>, 1>(name)
        {}

  // Access to the main events of the Communication class using event finders
	sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<TLmasterIF<TdataCl> >( *this, &TLmasterIF<TdataCl>::RequestStartEvent ); }
	sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<TLmasterIF<TdataCl> >( *this, &TLmasterIF<TdataCl>::RequestEndEvent ); }
	sc_event_finder& DataRequestStartEvent() const { return *new sc_event_finder_t<TLmasterIF<TdataCl> >( *this, &TLmasterIF<TdataCl>::DataRequestStartEvent ); }
	sc_event_finder& DataRequestEndEvent() const { return *new sc_event_finder_t<TLmasterIF<TdataCl> >( *this, &TLmasterIF<TdataCl>::DataRequestEndEvent ); }
	sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<TLmasterIF<TdataCl> >( *this, &TLmasterIF<TdataCl>::ResponseStartEvent ); }
	sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<TLmasterIF<TdataCl> >( *this, &TLmasterIF<TdataCl>::ResponseEndEvent ); }

};


#endif

