// 
//  Copyright 2003 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level 
//       Author : Norman Weyrich, Synopsys Inc.
//                (modified by Joe Chou, Sonics Inc.)
//         $Id: ocp_tl2_top1.cpp,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : OCP TL2 Example with 3 Master 1 Bus and 4 Slaves
// ============================================================================

#include "ocp_tl2_master.h"
#include "ocp_tl2_slave.h"
#include "ocp_tl2_bus.h"
#include "ocp_tl2_data_cl.h"
#include "tl_channel.h"  // needs ocp_tl2_globals.h and therefore must be
                         // included after ocp_tl2_master.h or ocp_tl2_slave.h

int sc_main(int, char*[])
{
  bool SynchronChannel = true;
  bool Pipelined = true;
  bool WriteResponse = true;

  // create OCP channel ch1 to ch7
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > ch1("ch1",SynchronChannel,true,true);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > ch2("ch2",SynchronChannel,true,true);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > ch3("ch3",SynchronChannel,true,true);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > ch4("ch4",SynchronChannel,true,true);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > ch5("ch5",SynchronChannel,true,true);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > ch6("ch6",SynchronChannel,true,true);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > ch7("ch7",SynchronChannel,true,true);

  // Change the default value for 'respaccept' parameter
  ch1.GetParamCl()->respaccept=true;
  ch2.GetParamCl()->respaccept=true;
  ch3.GetParamCl()->respaccept=true;
  ch4.GetParamCl()->respaccept=true;
  ch5.GetParamCl()->respaccept=true;
  ch6.GetParamCl()->respaccept=true;
  ch7.GetParamCl()->respaccept=true;

  // create slave sl1 to sl4
  OCP_TL2_Slave< OCP_TL2_TEMPL_DATA_CL >
            sl1("sl1",1,0x0,0x3FF,Pipelined,WriteResponse,1,1,2,2);
  OCP_TL2_Slave< OCP_TL2_TEMPL_DATA_CL >
            sl2("sl2",2,0x400,0xFFF,Pipelined,WriteResponse,2,2,2,2);
  OCP_TL2_Slave< OCP_TL2_TEMPL_DATA_CL >
            sl3("sl3",3,0x1000,0x13FF,Pipelined,WriteResponse,3,0,1,0);
  OCP_TL2_Slave< OCP_TL2_TEMPL_DATA_CL >
            sl4("sl4",4,0x1400,0x23FF,Pipelined,WriteResponse,1,0,1,0);

  // create master ma1 to ma3
  // - ma1 has the priority of 1 (lowest)
  OCP_TL2_Master< OCP_TL2_TEMPL_DATA_CL >
            ma1("ma1",1,1,Pipelined,WriteResponse,3,0,1,0);
  // - ma2 has the priority of 2 (middle)
  OCP_TL2_Master< OCP_TL2_TEMPL_DATA_CL >
            ma2("ma2",2,2,Pipelined,WriteResponse,2,0,2,0);
  // - ma3 has the priority of 3 (highest)
  OCP_TL2_Master<OCP_TL2_TEMPL_DATA_CL >
            ma3("ma3",3,2,Pipelined,WriteResponse,1,0,1,0);

  // create a bus
  OCP_TL2_Bus< OCP_TL2_TEMPL_DATA_CL, OCP_TL2_TEMPL_DATA_CL > 
         bu1("bu1",1,Pipelined,WriteResponse,1,1);

  // connect masters to OCP channels
  ma1.MasterP(ch1);
  ma2.MasterP(ch2);
  ma3.MasterP(ch3);

  // connect OCP channels to the bus' ports
  bu1.SlaveP(ch3);
  bu1.SlaveP(ch2);
  bu1.SlaveP(ch1);
  bu1.MasterP(ch4);
  bu1.MasterP(ch5);
  bu1.MasterP(ch6);
  bu1.MasterP(ch7);

  // connect slaves to OCP channels
  sl1.SlaveP(ch7);
  sl2.SlaveP(ch6);
  sl3.SlaveP(ch5);
  sl4.SlaveP(ch4);

  // run simulation
  sc_start(1000,TL_TIME_SCALE);
  //sc_start(20000000, TL_TIME_SCALE);

  //
  cout << "OCP_TL2_Top1 : Program finished at " 
       << sc_time_stamp().to_double() << endl;

  return(0);
}
