// 
//  Copyright 2005 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author :Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : TL3 simple example system 
//		  using delayed interfaces with implicit timing annotation
//
// ============================================================================


#include "ocp_tl3_master.h"
#include "ocp_tl3_slave.h"

#include "ocp_tl3_channel.h"

// OCP monitor package is installed
#ifdef PERF_MONITOR
#include "ocp_tl3_perf_monitor.h"
#endif

// SCV package is installed
#ifdef SCV
#include <scv.h>
#endif

int sc_main(int, char*[])
{

#ifdef SCV
  scv_tr_text_init();
  scv_tr_db db("ocp_db");
  scv_tr_db::set_default_db(&db);
#endif

  int end_time = 50000;

  typedef unsigned int Ta;
  typedef unsigned int Td;
  typedef basic_protocol::basic_request<Td,Ta> requestType;
  typedef basic_protocol::basic_response<Td>   responseType;

  OCP_TL3_Channel<requestType,responseType>  ch0("ch0");

#ifdef PERF_MONITOR
  OCP_TL3_Perf_Monitor<requestType,responseType> mon0("mon0");
  mon0.p_mon(ch0);
#endif

  // Creates masters and slaves 
  ocp_tl3_slave <Ta,Td> sl1("sl1");
  ocp_tl3_master<Ta,Td> ms1("ms1");

  // Connect masters and slaves using channels
  ms1.ocp(ch0.master_export);
  sl1.ocp_req(ch0.slave_export);
  sl1.ocp_resp(ch0.slave_export);

  static float fSimulationCPUTime = 0;
  clock();

  // start simulation 
  sc_start(end_time, SC_NS);

  fSimulationCPUTime = (float)( (float)clock() / (float)CLOCKS_PER_SEC );
  cerr << "SystemC simulated duration: " << sc_time_stamp() << endl;
  cerr << "                  CPU time: " << fSimulationCPUTime <<  endl;

  return (0);
};
