// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: master_r.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP - TL1 profile example
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_R_H
#define _OCP_TL1_MASTER_R_H

// Turn on debug messages
#define DEBUG_G1

#include <iostream>
#include "stdlib.h"

// User defined types
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl_param_cl.h"

#include "fifo.h"

class Master_r : public sc_module
{
public:  
  
  typedef OCPCHANNELBit32 Td;
  typedef OCPCHANNELBit32 Ta;

  // channel port
  OCP_TL1_MasterPort<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ipP;

  // TL1 clock
  sc_in_clk  clk;

  SC_HAS_PROCESS(Master_r);

  // constructor
  Master_r(sc_module_name name_);

  // destructor
  ~Master_r();

  // threads
  void proc();

  int cnt, burstcnt;
  int wraplen;
  unsigned int protbits;
  Ta addr;

  // Request group
  OCPRequestGrp<Td,Ta> req;

  // Response group
  OCPResponseGrp<Td> resp;

};


#endif // _OCP_TL1_MASTER_R_H
