// 
//  Copyright 2004 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: main.cc,v 1.6 2006/02/25 03:01:05 Anssi Exp $
//
//  Description : OCP API - Layer-1 Simple Example
//                Top level, synchronous Master <---> synchronous Slave
//
// ============================================================================

// Turn on user messages
#define DEBUG_G1

// Turn off OCP protocol checker, if installed
//#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel_clocked.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"

#include "ocp_tl1_trace_monitor.h"

int sc_main(int argc, char* argv[]) {


  // OCP parameters
  MapStringType  ocpParamMap;
  string ocpParamFileName;

  sc_clock clk;
  sc_signal<OCPRequestGrp<OCPCHANNELBit32, OCPCHANNELBit32> > t;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  // OCP channel
  typedef OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> data_type;
  typedef OCP_TL1_Channel_Clocked< data_type > channel_type;
  channel_type ch0("ocp0");

  // OCP trace monitor
  typedef OCP_TL1_Trace_Monitor< data_type > trace_monitor_type;
  trace_monitor_type tmon0("tmon0","ocp0.ocp");
  tmon0.p_mon(ch0);
  tmon0.p_clk(clk);

  // Submodules
  Slave< data_type > sl1("sl1");
  Master<data_type > ms1("ms1");

  // Set OCP configuration
  ch0.setConfiguration(ocpParamMap);

  // netlist
  ch0.p_clk(clk);

  ms1.ipP(ch0);
  ms1.clk(clk);
  
  sl1.tpP(ch0);
  sl1.clk(clk);
  sl1.t(t);

  // Simulator
  sc_start(50000, SC_NS);
  
  return(0);
}
