// Copyright (c) 2006 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: IntTypes.h,v 1.2 2007/02/05 14:22:46 guenzel Exp $
//
// Include and patch standard integer type headers

#ifndef _IntTypes_h_
#define _IntTypes_h_

#include <inttypes.h>

#if defined(__LP64__) || defined(_LP64)

#define SNX_LP64

// comment out this line to use int64_t instead of long long for 64 bit
#define USE_LONG_LONG

#ifdef USE_LONG_LONG
#define SC_NEED_LONG_OPS
#define SNX_NEED_LONG_OPS
#else
// using [u]int64_t not long-long for 64-bit - clashes with long
#endif

#define PTR_AS_INT "%ld"

#else

// long-long and long both needed
#define SC_NEED_LONG_OPS
#define SNX_NEED_LONG_OPS

#define PTR_AS_INT "%d"

#endif

// Compiler bug work-around for gcc 3.2.3 - re-iterate defs from inttypes.h
#if __GNUC__ == 3 && __GNUC_MINOR__ == 2

#ifdef SNX_LP64
#define REDECL_64 typedef long unsigned int  uint64_t;\
                  typedef long               int64_t;\
                  typedef long               intptr_t;
#else
#define REDECL_64 typedef unsigned long long uint64_t;\
                  typedef int                intptr_t;
#endif

#else

#ifdef SNX_LP64
#define REDECL_64 typedef long unsigned int  uint64_t;\
                  typedef long               int64_t;
#else
#define REDECL_64 typedef unsigned long long uint64_t;
#endif

#endif


#ifdef USE_LONG_LONG
typedef unsigned long long snx_uint64_t;
typedef long long          snx_int64_t;
#else
REDECL_64
typedef uint64_t snx_uint64_t;
typedef int64_t  snx_int64_t;
#endif
#endif // _IntTypes_h_

//REDECL_64
