// 
//  Copyright 2006 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Anssi Haverinen, Nokia
//                Herve Alexanian, Sonics
//         $Id: CPUMaster_2d.h,v 1.1 2007/08/21 02:23:35 halexan Exp $
//
//  Description:  TL0-TL1 adapter demo
//                
// ============================================================================


#ifndef _CPU_MASTER_H
#define _CPU_MASTER_H

#include "channel_types.h"
#include "sim_params.h"

#include <map>
#include <string>

#include <systemc.h>
#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_data_cl.h"
#include "ocp_tl1_channel.h"

#include "tl1_CPUMaster.h"
#include "read_map.h"


#include "ocp_tl0_port.h"
#include "ocp2_tl0_tl1_slave_adapter.h"
#include "ocp_tl1_slave_port.h"

// ----------------------------------------------------------------------------
//
//  Instantiation of the slave adapter template
//
// ----------------------------------------------------------------------------
template class OCP2_TL0_TL1_Slave_Adapter < OCP_TL1_DataCl<DType, AType >  >;


class master_tp_ports : public OCP2_TL0_MasterPorts {

public:

  // sc_port definitions

  sc_proxy_out_signal_port<sc_bv<3> > MCmd;
  sc_proxy_out_signal_port<sc_bv<A1Size> > MAddr;
  sc_proxy_out_signal_port <sc_bv<D1Size> > MData;
  sc_proxy_out_signal_port <sc_bv<D1Size/8> > MByteEn;
  sc_proxy_out_signal_port <bool> MRespAccept;
  sc_proxy_in_signal_port <bool> SCmdAccept;
  sc_proxy_in_signal_port <sc_bv<2> > SResp;
  sc_proxy_in_signal_port <sc_bv<D1Size> >SData;

  sc_proxy_out_signal_port<bool> MReqLast;
  sc_proxy_out_signal_port<bool> MReqRowLast;
  sc_proxy_out_signal_port<bool> MBurstSingleReq;
  sc_proxy_out_signal_port<unsigned int> MBurstLength;
  sc_proxy_out_signal_port<unsigned int> MBlockHeight;
  sc_proxy_out_signal_port<unsigned int> MBlockStride;
  sc_proxy_in_signal_port<bool> SRespLast;
  sc_proxy_in_signal_port<bool> SRespRowLast;

  // default constructor, names all ports
  master_tp_ports():
    MCmd( "MCmd" ),
    MAddr( "MAddr" ),
    MData( "MData" ),
    MByteEn( "MByteEn" ),
    MRespAccept ( "MRespAccept" ),
    SCmdAccept ( "SCmdAccept" ),
    SResp( "SResp" ),
    SData( "SData" ),
    MReqLast( "MReqLast" ),
    MReqRowLast( "MReqRowLast" ),
    MBurstSingleReq( "MBurstSingleReq" ),
    MBurstLength( "MBurstLength" ),
    MBlockHeight( "MBlockHeight" ),
    MBlockStride( "MBlockStride" ),
    SRespLast( "SRespLast" ),
    SRespRowLast( "SRespRowLast" )
  {}

  virtual ~master_tp_ports() {}

  // bind ports to base interface class members
  void bind()
  {
    mapPort( MCmd, OCP2_TL0_MasterPorts::MCmd );
    mapPort( MAddr , OCP2_TL0_MasterPorts::MAddr );
    mapPort( MData , OCP2_TL0_MasterPorts::MData );
    mapPort( MByteEn , OCP2_TL0_MasterPorts::MByteEn );
    mapPort( MRespAccept , OCP2_TL0_MasterPorts::MRespAccept );
    mapPort( SCmdAccept , OCP2_TL0_MasterPorts::SCmdAccept );
    mapPort( SResp , OCP2_TL0_MasterPorts::SResp );
    mapPort( SData , OCP2_TL0_MasterPorts::SData );
    mapPort( MReqLast, OCP2_TL0_MasterPorts::MReqLast );
    mapPort( MReqRowLast, OCP2_TL0_MasterPorts::MReqRowLast );
    mapPort( MBurstSingleReq, OCP2_TL0_MasterPorts::MBurstSingleReq );
    mapPort( MBurstLength, OCP2_TL0_MasterPorts::MBurstLength );
    mapPort( MBlockHeight, OCP2_TL0_MasterPorts::MBlockHeight );
    mapPort( MBlockStride, OCP2_TL0_MasterPorts::MBlockStride );
    mapPort( SRespLast, OCP2_TL0_MasterPorts::SRespLast );
    mapPort( SRespRowLast, OCP2_TL0_MasterPorts::SRespRowLast );
  }
};



SC_MODULE(CPUMaster)
{

  sc_out<sc_bv<3> > MCmd;
  sc_out<sc_bv<A1Size> > MAddr;
  sc_out<sc_bv<D1Size> > MData;
  sc_out<sc_bv<D1Size/8> > MByteEn;
  sc_out<bool> MRespAccept;
  sc_in<bool> SCmdAccept;
  sc_in<sc_bv<2> > SResp;
  sc_in<sc_bv<D1Size> > SData;

  sc_out<bool> MReqLast;
  sc_out<bool> MReqRowLast;
  sc_out<bool> MBurstSingleReq;
  sc_out<unsigned int> MBurstLength;
  sc_out<unsigned int> MBlockHeight;
  sc_out<unsigned int> MBlockStride;
  sc_in<bool> SRespLast;
  sc_in<bool> SRespRowLast;

  sc_in_clk Clk;

  tl1_CPUMaster  *mast1;
  OCP_TL1_Channel<OCP_TL1_DataCl< DType, AType > > *ocp0;
  OCP2_TL0_TL1_Slave_Adapter< OCP_TL1_DataCl<DType, AType > > * tp_tl0tl1;
  
  CPUMaster ( sc_module_name name ) :
    sc_module( name ){



    MapStringType   ocpParamMap;
    string  ocpParamFileName = "ocpParams_2d";
    
    if ( ! ocpParamFileName.empty() ) {
      readMapFromFile(ocpParamFileName, ocpParamMap);
    }
    ocp0 = new OCP_TL1_Channel<OCP_TL1_DataCl<DType, AType > > ((std::string)"ocp0", (sc_in_clk *) &Clk );
    ocp0->setConfiguration(ocpParamMap);
       
    mast1 = new tl1_CPUMaster("mast1");

    tp_tl0tl1 = new OCP2_TL0_TL1_Slave_Adapter< OCP_TL1_DataCl<DType, AType > > ( "tp_tl0tl1", OCP2_TL0_MasterPorts::Factory< master_tp_ports >());

    // port binding
    master_tp_ports& tp_tl0 = dynamic_cast<master_tp_ports&>( tp_tl0tl1->m_tl0Ports );
    

    tp_tl0tl1->SlaveP( *ocp0 ); 
    tp_tl0tl1->Clk(Clk ); 
    tp_tl0.MCmd( MCmd );
    tp_tl0.MAddr( MAddr );
    tp_tl0.MData ( MData );
    tp_tl0.MByteEn( MByteEn );
    tp_tl0.MRespAccept( MRespAccept );
    tp_tl0.SCmdAccept( SCmdAccept );
    tp_tl0.SResp( SResp );
    tp_tl0.SData( SData ); 

    tp_tl0.MReqLast( MReqLast );
    tp_tl0.MReqRowLast( MReqRowLast );
    tp_tl0.MBurstSingleReq( MBurstSingleReq );
    tp_tl0.MBurstLength( MBurstLength );
    tp_tl0.MBlockHeight( MBlockHeight );
    tp_tl0.MBlockStride( MBlockStride );
    tp_tl0.SRespLast( SRespLast );
    tp_tl0.SRespRowLast( SRespRowLast );     
      
    mast1->tpP(*ocp0);
    mast1->Clk(Clk); 
    
    
  }

    void end_of_elaboration() { 
      // configure channels and adapters 
      tp_tl0tl1->setClockPeriod(sc_time( 10, SC_NS ) );
    } 
  

};


#endif
