// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: master_nb.h,v 1.1 2005/05/21 00:37:25 anssi Exp $
//
//  Description : OCP - TL1 example non-blocking Master
//
// ============================================================================

#ifndef _OCP_TL1_MASTERNB_SYNC_H
#define _OCP_TL1_MASTERNB_SYNC_H
#define DEBUG_G1
#include <iostream>
#include "stdlib.h"

// User defined types
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl_param_cl.h"

template <typename TdataCl>
class MasterNb : public sc_module
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // channel port
  OCP_TL1_MasterPort<TdataCl> ipP;

  sc_in<bool> clk;

  SC_HAS_PROCESS(MasterNb);

  // constructor
  MasterNb(sc_module_name name_);

  // destructor
  ~MasterNb();

  // threads
  void proc();

  bool tmp;
  int cnt;

  // Request group
  OCPRequestGrp<Td,Ta> req;
  // Response group
  OCPResponseGrp<Td> resp;

};


#endif // _OCP_TL1_MASTERNB_SYNC_H
