// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: slave.h,v 1.2 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP - TL1 profile example
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

//#define DEBUG_G1

#include <iostream>

// OCP-IP Channel header files
#include "ocpip.h"

#include "byte_en_helper.h"

class Slave : public sc_core::sc_module {
public:  

  typedef ocpip::ocp_data_class_unsigned<32,32>::DataType Td;
  typedef ocpip::ocp_data_class_unsigned<32,32>::AddrType Ta;

  ocpip::ocp_slave_socket_tl1<32> tpP;

  sc_core::sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_core::sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc();

  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  // OCP request group
  tlm::tlm_generic_payload* req;
  bool ongoing_resp;
  tlm::tlm_generic_payload* rsp;
  tlm::tlm_phase phase;
  sc_core::sc_time time;
  unsigned int reqcnt;

  tlm::tlm_command last_request;
  ocpip::burst_seqs current_sequence;
  Td bytemask;
  Td memory[1024];
  Ta address;
  bool burststart;
};

#endif
