// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: slave.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP -  TL1 AMBD profile example
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#define DEBUG_G1

#include <iostream>

// OCP-IP Channel header files
#include "ocpip.h"
#include "fifo.h"

#include "byte_en_helper.h"

class Slave : public sc_core::sc_module {
  struct pending_req{
    pending_req(tlm::tlm_generic_payload* txn_, sc_dt::uint64 address_, unsigned int chunk_, bool resp_)
      : txn(txn_)
      , address(address_)
      , chunk(chunk_)
      ,resp(resp_){}
      
    tlm::tlm_generic_payload* txn;
    sc_dt::uint64 address;
    unsigned int chunk;
    bool resp;
  };
  
  struct outstanding_rsp{
    outstanding_rsp(tlm::tlm_generic_payload* txn_, sc_dt::uint64 address_, unsigned int chunk_)
      : txn(txn_)
      , address(address_)
      , chunk(chunk_){}
    tlm::tlm_generic_payload* txn;
    sc_dt::uint64 address;
    unsigned int chunk;
  };

public:  

  typedef ocpip::ocp_data_class_unsigned<32,32>::DataType Td;
  typedef ocpip::ocp_data_class_unsigned<32,32>::AddrType Ta;

  ocpip::ocp_slave_socket_tl1<32> ipP;

  sc_core::sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_core::sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc();
  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  // OCP request group
  tlm::tlm_generic_payload* req;
  //unsigned char is_srmd;

  // OCP request data group
  tlm::tlm_generic_payload* req_data;

  // OCP response group
  bool ongiong_resp;
  fifo<pending_req> pending_reqs;
  fifo<outstanding_rsp> outstanding_rsps;
  
  ocpip::burst_seqs current_seq;
  
  tlm::tlm_generic_payload* current_txn;
  unsigned int chunk_cnt;
  Td bytemask;
  Td memory[1024];
  Ta address;
  tlm::tlm_phase phase;
  sc_core::sc_time time;
};

#endif
