///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a generic OCP slave model for use in TL3
//                 modeling examples
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef __OCPIP_GENERIC_MEM_SLAVE_TL3_H__
#define __OCPIP_GENERIC_MEM_SLAVE_TL3_H__

#include <iostream>
#include "ocpip.h"

namespace ocpip_example {
template <typename addr_t, typename data_t>
class simple_memory_if {
public:
    virtual void write( addr_t, const data_t& )                      = 0;
    virtual void write( addr_t, data_t*, uint32_t length=1 )         = 0;
    virtual void read ( addr_t, data_t& )                      const = 0;
    virtual void read ( addr_t, data_t*, uint32_t length=1 )   const = 0;
    virtual void reset()                                             = 0;
    virtual ~simple_memory_if() {};
};

template <typename addr_t, typename data_t>
class simple_sparse_memory: public simple_memory_if<addr_t, data_t>
{
public:
    simple_sparse_memory( const data_t& default_value = 0 );
    virtual void write( addr_t, const data_t& );
    virtual void write( addr_t, data_t*, uint32_t length=1 );
    virtual void read ( addr_t, data_t& )                      const;
    virtual void read ( addr_t, data_t*, uint32_t length=1 )   const;
    virtual void reset();
private:
    std::map<addr_t, data_t> m_memory;
    data_t                   m_default_value;
};

template <unsigned int BUSWIDTH>
class generic_mem_slave_tl3 : public sc_core::sc_module {
public:
    generic_mem_slave_tl3( sc_core::sc_module_name );
    ocpip::ocp_slave_socket<BUSWIDTH>   m_socket;
private:
    simple_sparse_memory<uint64_t, unsigned char> m_memory;
    tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload&, tlm::tlm_phase&, sc_core::sc_time& );
};
}

#endif
