///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2011
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : James Aldis, Texas Instruments
//
//          $Id:
//
//  Description :  Common Structure for Testbench Auto-Checking
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


// initiator and target memory initialisation
char *initiator_memories[6][4];
char *target_memories[6][4];

void fill_initiator_memory(char *m, unsigned addrspace = 0) {
  static unsigned is[] = {0, 0, 0, 0};
  static bool first_call = true;
  if(first_call) for(unsigned t = 0; t < 6; t++)
    initiator_memories[t][0] = initiator_memories[t][1] = initiator_memories[t][2] = initiator_memories[t][3] = 0;
  first_call = false;
  initiator_memories[is[addrspace]++][addrspace] = m;
  for(unsigned a=0; a<MEM_SIZE; a++) m[a] = char(addrspace + a);
}

void fill_target_memory(char *m, unsigned addrspace = 0) {
  static unsigned ts[] = {0, 0, 0, 0};
  static bool first_call = true;
  if(first_call) for(unsigned t = 0; t < 6; t++)
    target_memories[t][0] = target_memories[t][1] = target_memories[t][2] = target_memories[t][3] = 0;
  first_call = false;
  target_memories[ts[addrspace]++][addrspace] = m;
  for(unsigned a=0; a<MEM_SIZE; a++) m[a] = char(addrspace + MEM_SIZE - a);
}


// transaction memory leak testing
unsigned nr_leak_test_created = 0;
unsigned nr_leak_test = 0;
unsigned nr_leak_test_deleted = 0;
sc_time leak_test_ctor_t;

class leak_test_cl: public tlm_extension<leak_test_cl> {
public:
  void free() {delete this;}
  void copy_from(tlm_extension_base const &) {}
  tlm_extension_base *clone() const {return 0;}
  leak_test_cl() {
    ++nr_leak_test_created;
    leak_test_ctor_t = sc_time_stamp();
  }
  ~leak_test_cl() {++nr_leak_test_deleted;}
};

void leak_test(tlm_generic_payload &pl) {
  ++nr_leak_test;
  if(!pl.get_extension<leak_test_cl>())
    pl.set_extension<leak_test_cl>(new leak_test_cl);
}


// clean termination of activity
void stop_sim(unsigned wait_for = 1) {
  static unsigned running = wait_for;
  if(--running > 0) return;
  sc_stop();
  running = false;

  cout << "stopping" << endl;
  cout << "  nr transactions:            " << nr_leak_test << endl;
  cout << "  nr payload objects needed:  " << nr_leak_test_created << endl;
  cout << "  nr payload objects deleted: " << nr_leak_test_deleted << endl;

  // verify that
  // - transaction objects and sticky extensions are not being wasted
  sc_assert(nr_leak_test_deleted == 0);
  // - transaction objects are being recycled after use.  simulation should
  //   run 4 times longer than time needed to create all the objects required
  sc_assert(leak_test_ctor_t * 4 < sc_time_stamp());
  sc_assert(nr_leak_test_created * 10 < nr_leak_test);

  // verify that all used memories' content is the same
  bool memories_all_match = true;
  cout << "memory checking" << endl;
  for(unsigned tb = 1; tb < 6; tb++) {
    char res;

    // initiators
    for(unsigned s = 0; s < 4; s++) {
      res = 'I';
      if(initiator_memories[tb][s] != 0) {
        for(unsigned a = 0; a < MEM_SIZE; a++) {
          if(initiator_memories[0][s][a] != initiator_memories[tb][s][a]) {
            res = '*';
            memories_all_match = false;
            // if(tb==3) cout << a << endl;
          }
        }
      } else res = '-';
      cout << res;
    }

    // targets
    for(unsigned s = 0; s < 4; s++) {
      res = 'T';
      if(target_memories[tb][s] != 0) {
        for(unsigned a = 0; a < MEM_SIZE; a++) {
          if(target_memories[0][s][a] != target_memories[tb][s][a]) {
            res = '*';
            memories_all_match = false;
            // if(tb==3)  cout << a << endl;
          }
        }
      } else res = '-';
      cout << res;
    }
    cout << endl;
  }
  sc_assert(memories_all_match);

  cout << "Testbench passed" << endl;
}

