// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP API - Layer-1 slave
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::Slave (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  resp.SData = 0;
  last_request = OCP_MCMD_IDLE;

  SC_THREAD(proc);
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc()
//
//  Synchronous slave process
//
// ----------------------------------------------------------------------------

template<class TdataCl> void Slave<TdataCl>::proc(){
  while(1) {
    is_req = tpP->getOCPRequestBlocking(req, true); // accept automatically
#ifdef DEBUG_G1
    cout << "Slave got request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  data  = " << req.MData << endl;
#endif
  }
} // end of method


// ----------------------------------------------------------------------------
//
//  Instantiation of the Slave
//
// ----------------------------------------------------------------------------
template class Slave< OCP_TL1_SIGNAL_CL >; // see ocp_tl1_globals.h

