header "pre_include_hpp" {
#include <iostream>
using namespace std;
}

header "post_include_hpp" {
#include "ModelConfigGlobals.h"
}

// set the generated language
options { language = "Cpp"; }

// =====================================================
// parser definition
// =====================================================

// optional class code preamble
{
}

// parser class code
class SCIParser extends Parser;

// parser options
options { codeGenMakeSwitchThreshold = 3; codeGenBitsetTestThreshold = 4; }

// optional tokens
tokens {
    SCI = "sci";
    DEFAULTCLOCK = "default_clock";
    CLOCK = "clock";
    CONNECTION = "connection";
    INSTANCE = "instance";
    PARAM = "param";
    INTERFACE = "interface";
}

// optional action for instance vars/methods
{
}

// ------------
// parser rules
// ------------

program
[MAPType& map,
 SETType& conn_list,
 SETType& inst_list,
 SETType& clk_list]
    : headerSection ( defaultClockStatement[map,clk_list] )?
      body[map,conn_list,inst_list,clk_list]
    ;

headerSection
    : SCI s:ID
      {
          // -------------------
          // check the header ID
          // -------------------
          if ("ocpip" != s->getText()) {
              std::cout << endl
                        << "FATAL ERROR: unrecognized file header"
                        << endl;
              exit(-1);
          }
      }
      major:INT PERIOD minor:INT
      {
          // ------------------------
          // check the version number
          // ------------------------
          bool         error = false;
          int          major_num = 0;
          int          minor_num = 0;

          major_num = atoi(major->getText().c_str());
          minor_num = atoi(minor->getText().c_str());

          // checks
          if ((major_num < 0) || (major_num > MAJOR_NUM)) error = true;
          if ((major_num == MAJOR_NUM) &&
              ((minor_num < 0) || (minor_num > MINOR_NUM))) {
              error = true;
          }
          if (error) {
              std::cout << endl
                        << "FATAL ERROR: can't handle version number: "
                        << major_num << "." << minor_num << endl;
              exit(-1);
          }
      }
      ENDOFLINE
    ;

defaultClockStatement
[MAPType& map, SETType& clk_list]
    : DEFAULTCLOCK s:ID i:INT ENDOFLINE
      {
          // add the clock to the clock list
          clk_list.insert(s->getText());

          // add a map entry for this clock
          map.insert(MAPType::value_type("."+s->getText(),"s:clock"));

          // add a map entry for this clock's rate number
          map.insert(MAPType::value_type("."+s->getText()+".rate_number",
                                         "i:"+i->getText()));
      }
      ( parameter[map,s->getText()] )*
    ;

body
[MAPType& map,
 SETType& conn_list,
 SETType& inst_list,
 SETType& clk_list]
    : ( clockStatement[map,clk_list] )*
      ( connectionStatement[map,"",conn_list] )*
      ( instanceStatement[map,"",conn_list,inst_list,clk_list] )*
    ;

clockStatement
[MAPType& map, SETType& clk_list]
    : CLOCK s:ID i:INT ENDOFLINE
      {
          // add the clock to the clock list
          clk_list.insert(s->getText());

          // add a map entry for this clock
          map.insert(MAPType::value_type("."+s->getText(),"s:clock"));

          // add a map entry for this clock's rate number
          map.insert(MAPType::value_type("."+s->getText()+".rate_number",
                                         "i:"+i->getText()));
      }
      ( parameter[map,s->getText()] )*
    ;

connectionStatement
[MAPType& map, string prefix, SETType& conn_list]
    : CONNECTION name:ID type:ID ENDOFLINE
      {
          // add the connection to the connection list
          conn_list.insert(name->getText());

          // add a map entry for this connection
          map.insert(MAPType::value_type("."+name->getText(),
                                         "s:"+type->getText()));
      }
      ( CLOCK clk:ID ENDOFLINE
      {
          // add a map entry for this connection's clock
          map.insert(MAPType::value_type("."+name->getText()+".clock",
                                         "s:"+clk->getText()));
      }
      )?
      ( parameter[map,prefix+"."+name->getText()] )*
    ;

instanceStatement
[MAPType& map,
 string prefix,
 SETType& conn_list,
 SETType& inst_list,
 SETType& clk_list]
    : INSTANCE name:ID type:ID ENDOFLINE
      {
          // add the instance to the instance list
          inst_list.insert(name->getText());

          // add a map entry for this instance
          map.insert(MAPType::value_type("."+name->getText(),
                                         "s:"+type->getText()));
      }
      ( CLOCK clk:ID ENDOFLINE
      {
          // add a map entry for this instance's clock
          map.insert(MAPType::value_type("."+name->getText()+".clock",
                                         "s:"+clk->getText()));
      }
      )?
      ( parameter[map,prefix+"."+name->getText()] )*
      ( interface[map,prefix+"."+name->getText()] )*
    ;

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// parameter rules

parameter
[MAPType& map, string prefix]
{ string param_name; string param_value; }
    : PARAM
      ( n1:ID { param_name = n1->getText(); }
      | CLOCK { param_name = "clock"; }
      )
      ( param_value=intFloatParameter | param_value=stringParameter )
      {
          // add a map entry for this parameter
          map.insert(MAPType::value_type(prefix+"."+param_name,param_value));
      }
      ENDOFLINE
    ;

stringParameter
returns [string value]
    : s:STRING "S"
      {
          string str(s->getText(),1,s->getText().length()-2);
          value = "s:"+str;
      }
    ;

// explicit syntactic predicates , ( xxx )=>, are used in this rule
intFloatParameter
returns [string value]
    : ( INT PERIOD )=> i1:INT PERIOD i2:INT "F"
      { value = "f:"+i1->getText()+"."+i2->getText(); }
    | ( INT "L" )=> i3:INT "L"
      { value = "l:"+i3->getText(); }
    | i4:INT "I"
      { value = "i:"+i4->getText(); }
    ;

// ---------------------------------------------------------------------

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
// interface rules

interface
[MAPType& map, string prefix]
{ string intf1; string intf2; }
    : INTERFACE id:ID intf1=intfName intf2=intfName
      {
          // add a map entry for this parameter
          map.insert(MAPType::value_type(prefix+".interface."+id->getText(),
                                         "s:"+intf1+":"+intf2));
      }
      ENDOFLINE
    ;

intfName
returns [string value]
    : ( id:ID { value = id->getText(); } | QUESTIONMARK { value = "?"; } )
    ;
// ---------------------------------------------------------------------

// =====================================================
// lexer definition
// =====================================================

// optional class code preamble
{
}

// lexer class
class SCILexer extends Lexer;

// lexer options
//options { k = 2; caseSensitive = false; testLiterals = false; }
options { k = 2; caseSensitive = false; }

// optional tokens

// optional action for instance vars/methods
{
}

// -------------
// lexical rules
// -------------

PERIOD : '.' ;
SEMICOLON : ';' ;
COLON : ':' ;
COMMA : ',' ;
QUESTIONMARK : '?' ;
GREATER : '>' ;
EQUAL : '=' ;
SMALLER : '<' ;
ATSIGN : '@' ;
PSIGN : '#' ;

COMMENT : "//" ( ~'\n' )* '\n'
          { _ttype = ANTLR_USE_NAMESPACE(antlr)Token::SKIP; newline(); }
        ;

WS : ( ' ' | '\t' )+
     { _ttype = ANTLR_USE_NAMESPACE(antlr)Token::SKIP; }
   ;

ENDOFLINE : '\n'
            { newline(); }
          ;

STRING : '"' ( ~( '"' | '\n' ) )* '"'
       ;

INT : ( '-' | '+' )* ( '0'..'9' )+
    ;

ID options { testLiterals = true; }
   : ( 'a'..'z' ) ( 'a'..'z' | '0'..'9' | '_' | '.' | '(' | ')' )*
   ;
