// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: main.cc,v 1.6 2006/03/11 21:35:52 Anssi Exp $
//
//  Description : OCP API - Layer-2 Simple Example
//                Top level
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
//#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
//#include "ocp_tl2_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl2_channel.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"

#ifdef PERF_MONITOR
#include "ocp_tl2_perf_monitor.h"
#endif
#ifdef TRACE_MONITOR
#include "ocp_tl2_trace_monitor.h"
#endif

#ifdef PERF_MONITOR
#ifdef SCV
#include <scv.h>
#endif
#endif
int sc_main(int argc, char* argv[]) {

  // OCP parameters
  MapStringType  ocpParamMap;
  string ocpParamFileName;

  OCP_TL2_Channel<OCPCHANNELBit32, OCPCHANNELBit32 > ch0("ocp0");

  // Submodules
  Slave<OCPCHANNELBit32, OCPCHANNELBit32 > sl1("sl1");
  Master<OCPCHANNELBit32, OCPCHANNELBit32 > ms1("ms1");

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  // Set parameters to channel
  ch0.setConfiguration(ocpParamMap);

  // Netlist
  ms1.ipP(ch0);

  sl1.tpP(ch0);

#ifdef PERF_MONITOR
  // transaction recording monitor

#ifdef SCV
  scv_tr_text_init();
  scv_tr_db db("ocp_db");
  scv_tr_db::set_default_db(&db);
#endif
  bool ChannelRecording = true;
  bool SystemRecording = false;
  bool BurstRecording = false;
  typedef OCP_TL2_Perf_Monitor<OCPCHANNELBit32, OCPCHANNELBit32> perf_monitor_type;
  perf_monitor_type pmon("mon", ChannelRecording, SystemRecording, false, false,1,BurstRecording);
  pmon.p_mon(ch0);
#endif

#ifdef TRACE_MONITOR
  typedef OCP_TL2_Trace_Monitor<OCPCHANNELBit32, OCPCHANNELBit32> trace_monitor_type;
 ofstream trace_file("ch0.ocp_trace");
 trace_monitor_type tmon("mon", &trace_file);
 tmon.p_mon(ch0);
#endif

  // Simulator
  sc_start(50, SC_NS);

  return(0);
}
