// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//
//          $Id:
//
//  Description : OCP TL3 Monitor Interface
//
// ============================================================================

#ifndef _OCP_TL3_MONITOR_IF
#define _OCP_TL3_MONITOR_IF

#include "systemc.h"

#include "ocp_tl3_monitor_observer_if.h"

template 
< 
  typename REQ, 
  typename RESP
>
class OCP_TL3_MonitorPeekIF :  virtual public sc_interface
{
public:
  typedef REQ			request_type;
  typedef RESP			response_type;

  // port names
  virtual const std::string	peekChannelName()	const = 0;
  virtual const std::string	peekMasterPortName()	const = 0;
  virtual const std::string	peekSlavePortName()	const = 0;

  // transactions
  virtual const request_type&	peekRequest()	const = 0;
  virtual const response_type&	peekResponse()	const = 0;
  virtual bool			requestInProgress()	const = 0;
  virtual bool			responseInProgress()	const = 0;
};

template 
< 
  typename REQ, 
  typename RESP
>
class OCP_TL3_MonitorRegisterIF :  virtual public sc_interface
{
public:
  typedef OCP_TL3_Monitor_ObserverIF<REQ,RESP>	observer_type;

  // transactions
  virtual void			RegisterRequestStart (observer_type *) = 0;
  virtual void			RegisterRequestEnd   (observer_type *) = 0;
  virtual void			RegisterResponseStart(observer_type *) = 0;
  virtual void			RegisterResponseEnd  (observer_type *)  = 0;
};

template 
< 
  typename REQ, 
  typename RESP
>
class OCP_TL3_MonitorIF :  
  virtual public OCP_TL3_MonitorPeekIF<REQ,RESP>,
  virtual public OCP_TL3_MonitorRegisterIF<REQ,RESP>
{};

#endif // _OCP_TL3_MONITOR_IF
