/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2003 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.4 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

// ============================================================================
//      Project : Generic SystemC TL Communication Methodology
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//         Date : 11/15/2002
//
//  Description : TL3 Example for ATM cell transport
//    Point-to-Point Connection
//    1 Master, 1 Channel, 1 Slave
// ============================================================================

#include "tl3_master.h"
#include "tl3_slave.h"
#include "tl3_data_cl.h"
#include "tl_channel.h"  // needs tl3_globals.h and therefore must be included 
                         // after tl3_master.h or tl3_slave.h



int sc_main(int, char*[])
{
  bool SynchronChannel = false;
  bool UseSyncEvents = true;
  bool UseDefaultEvents = false;

  bool WriteResponse = false;

  TL_Channel<TL3_TEMPL_DATA_CL > ch1("ch1", SynchronChannel,
                                            UseSyncEvents, UseDefaultEvents);

  TL3_Slave <TL3_TEMPL_DATA_CL >  sl1("sl1", 1, WriteResponse);

  TL3_Master<TL3_TEMPL_DATA_CL >  ma1("ma1", 1, WriteResponse);


  ma1.MasterP(ch1);
  sl1.SlaveP(ch1);


  sc_start(1, TL_TIME_SCALE);


  cout << "TL3_Top0 : Program finished at " 
       << sc_time_stamp().to_seconds() << endl;

  return(0);
}
