/* $ANTLR 2.7.1: "format.g" -> "SCIParser.cpp"$ */
#include "SCIParser.hpp"
#include "antlr/NoViableAltException.hpp"
#include "antlr/SemanticException.hpp"
#line 18 "format.g"


#line 9 "SCIParser.cpp"
SCIParser::SCIParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,k)
{
	setTokenNames(_tokenNames);
}

SCIParser::SCIParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,1)
{
	setTokenNames(_tokenNames);
}

SCIParser::SCIParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,k)
{
	setTokenNames(_tokenNames);
}

SCIParser::SCIParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,1)
{
	setTokenNames(_tokenNames);
}

SCIParser::SCIParser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(state,1)
{
	setTokenNames(_tokenNames);
}

void SCIParser::program(
	MAPType& map,
 SETType& conn_list,
 SETType& inst_list,
 SETType& clk_list
) {
	
	try {      // for error handling
		headerSection();
		{
		if ((LA(1)==DEFAULTCLOCK)) {
			defaultClockStatement(map,clk_list);
		}
		else if ((_tokenSet_0.member(LA(1)))) {
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
		body(map,conn_list,inst_list,clk_list);
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_1);
		} else {
			throw ex;
		}
	}
}

void SCIParser::headerSection() {
	ANTLR_USE_NAMESPACE(antlr)RefToken  s = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  major = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  minor = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		match(SCI);
		s = LT(1);
		match(ID);
		if ( inputState->guessing==0 ) {
#line 57 "format.g"
			
			// -------------------
			// check the header ID
			// -------------------
			if ("ocpip" != s->getText()) {
			std::cout << endl
			<< "FATAL ERROR: unrecognized file header"
			<< endl;
			exit(-1);
			}
			
#line 95 "SCIParser.cpp"
		}
		major = LT(1);
		match(INT);
		match(PERIOD);
		minor = LT(1);
		match(INT);
		if ( inputState->guessing==0 ) {
#line 69 "format.g"
			
			// ------------------------
			// check the version number
			// ------------------------
			bool         error = false;
			int          major_num = 0;
			int          minor_num = 0;
			
			major_num = atoi(major->getText().c_str());
			minor_num = atoi(minor->getText().c_str());
			
			// checks
			if ((major_num < 0) || (major_num > MAJOR_NUM)) error = true;
			if ((major_num == MAJOR_NUM) &&
			((minor_num < 0) || (minor_num > MINOR_NUM))) {
			error = true;
			}
			if (error) {
			std::cout << endl
			<< "FATAL ERROR: can't handle version number: "
			<< major_num << "." << minor_num << endl;
			exit(-1);
			}
			
#line 128 "SCIParser.cpp"
		}
		match(ENDOFLINE);
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_2);
		} else {
			throw ex;
		}
	}
}

void SCIParser::defaultClockStatement(
	MAPType& map, SETType& clk_list
) {
	ANTLR_USE_NAMESPACE(antlr)RefToken  s = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		match(DEFAULTCLOCK);
		s = LT(1);
		match(ID);
		i = LT(1);
		match(INT);
		match(ENDOFLINE);
		if ( inputState->guessing==0 ) {
#line 99 "format.g"
			
			// add the clock to the clock list
			clk_list.insert(s->getText());
			
			// add a map entry for this clock
			map.insert(MAPType::value_type("."+s->getText(),"s:clock"));
			
			// add a map entry for this clock's rate number
			map.insert(MAPType::value_type("."+s->getText()+".rate_number",
			"i:"+i->getText()));
			
#line 169 "SCIParser.cpp"
		}
		{
		for (;;) {
			if ((LA(1)==PARAM)) {
				parameter(map,s->getText());
			}
			else {
				goto _loop6;
			}
			
		}
		_loop6:;
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_0);
		} else {
			throw ex;
		}
	}
}

void SCIParser::body(
	MAPType& map,
 SETType& conn_list,
 SETType& inst_list,
 SETType& clk_list
) {
	
	try {      // for error handling
		{
		for (;;) {
			if ((LA(1)==CLOCK)) {
				clockStatement(map,clk_list);
			}
			else {
				goto _loop9;
			}
			
		}
		_loop9:;
		}
		{
		for (;;) {
			if ((LA(1)==CONNECTION)) {
				connectionStatement(map,"",conn_list);
			}
			else {
				goto _loop11;
			}
			
		}
		_loop11:;
		}
		{
		for (;;) {
			if ((LA(1)==INSTANCE)) {
				instanceStatement(map,"",conn_list,inst_list,clk_list);
			}
			else {
				goto _loop13;
			}
			
		}
		_loop13:;
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_1);
		} else {
			throw ex;
		}
	}
}

void SCIParser::parameter(
	MAPType& map, string prefix
) {
	ANTLR_USE_NAMESPACE(antlr)RefToken  n1 = ANTLR_USE_NAMESPACE(antlr)nullToken;
#line 191 "format.g"
	string param_name; string param_value;
#line 257 "SCIParser.cpp"
	
	try {      // for error handling
		match(PARAM);
		{
		if ((LA(1)==ID)) {
			n1 = LT(1);
			match(ID);
			if ( inputState->guessing==0 ) {
#line 195 "format.g"
				param_name = n1->getText();
#line 268 "SCIParser.cpp"
			}
		}
		else if ((LA(1)==CLOCK)) {
			match(CLOCK);
			if ( inputState->guessing==0 ) {
#line 196 "format.g"
				param_name = "clock";
#line 276 "SCIParser.cpp"
			}
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		if ((LA(1)==INT)) {
			param_value=intFloatParameter();
		}
		else if ((LA(1)==STRING)) {
			param_value=stringParameter();
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState->guessing==0 ) {
#line 199 "format.g"
			
			// add a map entry for this parameter
			map.insert(MAPType::value_type(prefix+"."+param_name,param_value));
			
#line 302 "SCIParser.cpp"
		}
		match(ENDOFLINE);
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		} else {
			throw ex;
		}
	}
}

void SCIParser::clockStatement(
	MAPType& map, SETType& clk_list
) {
	ANTLR_USE_NAMESPACE(antlr)RefToken  s = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		match(CLOCK);
		s = LT(1);
		match(ID);
		i = LT(1);
		match(INT);
		match(ENDOFLINE);
		if ( inputState->guessing==0 ) {
#line 126 "format.g"
			
			// add the clock to the clock list
			clk_list.insert(s->getText());
			
			// add a map entry for this clock
			map.insert(MAPType::value_type("."+s->getText(),"s:clock"));
			
			// add a map entry for this clock's rate number
			map.insert(MAPType::value_type("."+s->getText()+".rate_number",
			"i:"+i->getText()));
			
#line 343 "SCIParser.cpp"
		}
		{
		for (;;) {
			if ((LA(1)==PARAM)) {
				parameter(map,s->getText());
			}
			else {
				goto _loop16;
			}
			
		}
		_loop16:;
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_0);
		} else {
			throw ex;
		}
	}
}

void SCIParser::connectionStatement(
	MAPType& map, string prefix, SETType& conn_list
) {
	ANTLR_USE_NAMESPACE(antlr)RefToken  name = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  type = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  clk = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		match(CONNECTION);
		name = LT(1);
		match(ID);
		type = LT(1);
		match(ID);
		match(ENDOFLINE);
		if ( inputState->guessing==0 ) {
#line 143 "format.g"
			
			// add the connection to the connection list
			conn_list.insert(name->getText());
			
			// add a map entry for this connection
			map.insert(MAPType::value_type("."+name->getText(),
			"s:"+type->getText()));
			
#line 393 "SCIParser.cpp"
		}
		{
		if ((LA(1)==CLOCK)) {
			match(CLOCK);
			clk = LT(1);
			match(ID);
			match(ENDOFLINE);
			if ( inputState->guessing==0 ) {
#line 152 "format.g"
				
				// add a map entry for this connection's clock
				map.insert(MAPType::value_type("."+name->getText()+".clock",
				"s:"+clk->getText()));
				
#line 408 "SCIParser.cpp"
			}
		}
		else if ((_tokenSet_4.member(LA(1)))) {
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		for (;;) {
			if ((LA(1)==PARAM)) {
				parameter(map,prefix+"."+name->getText());
			}
			else {
				goto _loop20;
			}
			
		}
		_loop20:;
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_5);
		} else {
			throw ex;
		}
	}
}

void SCIParser::instanceStatement(
	MAPType& map,
 string prefix,
 SETType& conn_list,
 SETType& inst_list,
 SETType& clk_list
) {
	ANTLR_USE_NAMESPACE(antlr)RefToken  name = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  type = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  clk = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		match(INSTANCE);
		name = LT(1);
		match(ID);
		type = LT(1);
		match(ID);
		match(ENDOFLINE);
		if ( inputState->guessing==0 ) {
#line 168 "format.g"
			
			// add the instance to the instance list
			inst_list.insert(name->getText());
			
			// add a map entry for this instance
			map.insert(MAPType::value_type("."+name->getText(),
			"s:"+type->getText()));
			
#line 470 "SCIParser.cpp"
		}
		{
		if ((LA(1)==CLOCK)) {
			match(CLOCK);
			clk = LT(1);
			match(ID);
			match(ENDOFLINE);
			if ( inputState->guessing==0 ) {
#line 177 "format.g"
				
				// add a map entry for this instance's clock
				map.insert(MAPType::value_type("."+name->getText()+".clock",
				"s:"+clk->getText()));
				
#line 485 "SCIParser.cpp"
			}
		}
		else if ((_tokenSet_6.member(LA(1)))) {
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		for (;;) {
			if ((LA(1)==PARAM)) {
				parameter(map,prefix+"."+name->getText());
			}
			else {
				goto _loop24;
			}
			
		}
		_loop24:;
		}
		{
		for (;;) {
			if ((LA(1)==INTERFACE)) {
				interface(map,prefix+"."+name->getText());
			}
			else {
				goto _loop26;
			}
			
		}
		_loop26:;
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_7);
		} else {
			throw ex;
		}
	}
}

void SCIParser::interface(
	MAPType& map, string prefix
) {
	ANTLR_USE_NAMESPACE(antlr)RefToken  id = ANTLR_USE_NAMESPACE(antlr)nullToken;
#line 232 "format.g"
	string intf1; string intf2;
#line 537 "SCIParser.cpp"
	
	try {      // for error handling
		match(INTERFACE);
		id = LT(1);
		match(ID);
		intf1=intfName();
		intf2=intfName();
		if ( inputState->guessing==0 ) {
#line 236 "format.g"
			
			// add a map entry for this parameter
			map.insert(MAPType::value_type(prefix+".interface."+id->getText(),
			"s:"+intf1+":"+intf2));
			
#line 552 "SCIParser.cpp"
		}
		match(ENDOFLINE);
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_8);
		} else {
			throw ex;
		}
	}
}

string  SCIParser::intFloatParameter() {
#line 216 "format.g"
	string value;
#line 570 "SCIParser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  i1 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  i2 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  i3 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  i4 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		bool synPredMatched33 = false;
		if (((LA(1)==INT))) {
			int _m33 = mark();
			synPredMatched33 = true;
			inputState->guessing++;
			try {
				{
				match(INT);
				match(PERIOD);
				}
			}
			catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
				synPredMatched33 = false;
			}
			rewind(_m33);
			inputState->guessing--;
		}
		if ( synPredMatched33 ) {
			i1 = LT(1);
			match(INT);
			match(PERIOD);
			i2 = LT(1);
			match(INT);
			match(LITERAL_F);
			if ( inputState->guessing==0 ) {
#line 219 "format.g"
				value = "f:"+i1->getText()+"."+i2->getText();
#line 604 "SCIParser.cpp"
			}
		}
		else {
			bool synPredMatched35 = false;
			if (((LA(1)==INT))) {
				int _m35 = mark();
				synPredMatched35 = true;
				inputState->guessing++;
				try {
					{
					match(INT);
					match(LITERAL_L);
					}
				}
				catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
					synPredMatched35 = false;
				}
				rewind(_m35);
				inputState->guessing--;
			}
			if ( synPredMatched35 ) {
				i3 = LT(1);
				match(INT);
				match(LITERAL_L);
				if ( inputState->guessing==0 ) {
#line 221 "format.g"
					value = "l:"+i3->getText();
#line 632 "SCIParser.cpp"
				}
			}
			else if ((LA(1)==INT)) {
				i4 = LT(1);
				match(INT);
				match(LITERAL_I);
				if ( inputState->guessing==0 ) {
#line 223 "format.g"
					value = "i:"+i4->getText();
#line 642 "SCIParser.cpp"
				}
			}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_9);
		} else {
			throw ex;
		}
	}
	return value;
}

string  SCIParser::stringParameter() {
#line 206 "format.g"
	string value;
#line 665 "SCIParser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  s = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		s = LT(1);
		match(STRING);
		match(LITERAL_S);
		if ( inputState->guessing==0 ) {
#line 209 "format.g"
			
			string str(s->getText(),1,s->getText().length()-2);
			value = "s:"+str;
			
#line 678 "SCIParser.cpp"
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_9);
		} else {
			throw ex;
		}
	}
	return value;
}

string  SCIParser::intfName() {
#line 244 "format.g"
	string value;
#line 696 "SCIParser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  id = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	try {      // for error handling
		{
		if ((LA(1)==ID)) {
			id = LT(1);
			match(ID);
			if ( inputState->guessing==0 ) {
#line 246 "format.g"
				value = id->getText();
#line 707 "SCIParser.cpp"
			}
		}
		else if ((LA(1)==QUESTIONMARK)) {
			match(QUESTIONMARK);
			if ( inputState->guessing==0 ) {
#line 246 "format.g"
				value = "?";
#line 715 "SCIParser.cpp"
			}
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		if( inputState->guessing == 0 ) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_10);
		} else {
			throw ex;
		}
	}
	return value;
}

const char* SCIParser::_tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"\"sci\"",
	"\"default_clock\"",
	"\"clock\"",
	"\"connection\"",
	"\"instance\"",
	"\"param\"",
	"\"interface\"",
	"ID",
	"INT",
	"PERIOD",
	"ENDOFLINE",
	"STRING",
	"\"S\"",
	"\"F\"",
	"\"L\"",
	"\"I\"",
	"QUESTIONMARK",
	"SEMICOLON",
	"COLON",
	"COMMA",
	"GREATER",
	"EQUAL",
	"SMALLER",
	"ATSIGN",
	"PSIGN",
	"COMMENT",
	"WS",
	0
};

const unsigned long SCIParser::_tokenSet_0_data_[] = { 450UL, 0UL, 0UL, 0UL };
// EOF "clock" "connection" "instance" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_0(_tokenSet_0_data_,4);
const unsigned long SCIParser::_tokenSet_1_data_[] = { 2UL, 0UL, 0UL, 0UL };
// EOF 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_1(_tokenSet_1_data_,4);
const unsigned long SCIParser::_tokenSet_2_data_[] = { 482UL, 0UL, 0UL, 0UL };
// EOF "default_clock" "clock" "connection" "instance" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_2(_tokenSet_2_data_,4);
const unsigned long SCIParser::_tokenSet_3_data_[] = { 1986UL, 0UL, 0UL, 0UL };
// EOF "clock" "connection" "instance" "param" "interface" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_3(_tokenSet_3_data_,4);
const unsigned long SCIParser::_tokenSet_4_data_[] = { 898UL, 0UL, 0UL, 0UL };
// EOF "connection" "instance" "param" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_4(_tokenSet_4_data_,4);
const unsigned long SCIParser::_tokenSet_5_data_[] = { 386UL, 0UL, 0UL, 0UL };
// EOF "connection" "instance" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_5(_tokenSet_5_data_,4);
const unsigned long SCIParser::_tokenSet_6_data_[] = { 1794UL, 0UL, 0UL, 0UL };
// EOF "instance" "param" "interface" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_6(_tokenSet_6_data_,4);
const unsigned long SCIParser::_tokenSet_7_data_[] = { 258UL, 0UL, 0UL, 0UL };
// EOF "instance" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_7(_tokenSet_7_data_,4);
const unsigned long SCIParser::_tokenSet_8_data_[] = { 1282UL, 0UL, 0UL, 0UL };
// EOF "instance" "interface" 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_8(_tokenSet_8_data_,4);
const unsigned long SCIParser::_tokenSet_9_data_[] = { 16384UL, 0UL, 0UL, 0UL };
// ENDOFLINE 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_9(_tokenSet_9_data_,4);
const unsigned long SCIParser::_tokenSet_10_data_[] = { 1067008UL, 0UL, 0UL, 0UL };
// ID ENDOFLINE QUESTIONMARK 
const ANTLR_USE_NAMESPACE(antlr)BitSet SCIParser::_tokenSet_10(_tokenSet_10_data_,4);


