// 
//  Copyright 2043 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com
//         Date : 07/01/2004
//
//  Description : Layer Adapter, TL0-TL1 example, Asynchronous TL0 OCP Master
//  (OCP2.0) with burst support
// ============================================================================

#ifndef _TL0_OCP_MASTER_ASYNC_BURST_H
#define _TL0_OCP_MASTER_ASYNC_BURST_H

#include "systemc.h"
#include "ocp_globals.h"

using namespace std;

// ----------------------------------------------------------------------------
// Class : OCP_TL0_Master_async_burst 
// 
// Description: Asynchronous TL0 OCP Master 
// ----------------------------------------------------------------------------

template <class TdataCl> class OCP_TL0_Master_async_burst
  : public sc_module
{
public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // Basic OCP ports
  sc_in   <bool>      Clk;
  sc_out  <sc_bv<3> >	MCmd;
  sc_out 	<Ta>      	MAddr;
  sc_out 	<Td>      	MData;
  sc_in	  <bool>	    SCmdAccept;
  sc_in	  <Td>      	SData;
  sc_in	  <sc_bv<2> > SResp;
  sc_out 	<bool>	    MRespAccept;

  // TL0 Burst Extension
  sc_out <unsigned int>       MByteEn;
  sc_out <unsigned int>       MBurstLength;
  sc_out <bool>               MBurstPrecise;
  sc_out <OCPMBurstSeqType >  MBurstSeq;
  sc_out <bool>               MBurstSingleReq;


  SC_HAS_PROCESS(OCP_TL0_Master_async_burst);

  // constructor
  OCP_TL0_Master_async_burst(sc_module_name name_
            , sc_time RequestDelay = sc_time(0)
            , sc_time ResponseDelay = sc_time(0)
           );

  // destructor
  ~OCP_TL0_Master_async_burst();

  // methods
  void GetResponse();
  void SendRequest();

  // Master parameters
  sc_time   m_RequestDelay;
  sc_time   m_ResponseDelay;

};


#endif // _TL0_OCP_MASTER_ASYNC_BURST_H
