// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Joe Chou, Sonics Inc., joechou@sonicsinc.com 
//         Date : 02/15/2003
//
//  Description : OCP Transaction Level communication class.
//                This class gives the modules read access to
//                the events and states used in the Channel.
//                We recommend users not to change this class.
//
// ============================================================================

// This file contains the definition of the classes:
// class CommCl


#ifndef _TL_Comm_CL
#define _TL_Comm_CL

// This class contains the states and events used by the
// communication mechanism of the Channel. These states and events
// must not be changed by Masters and Slaves.
// The purpose to export these states and events is to
// give Masters and Slaves read access. Again, these access must be read only.
// For the (intended) normal use of the Channel this class should not be
// changed.

class CommCl
{
 public:

  // Constructor
  CommCl()
    : RequestStart(false)
    , RequestEnd(false)
    , ResponseStart(false)
    , ResponseEnd(false)
    , DataRequestStart(false)
    , DataRequestEnd(false)
    , RequestPending(false)
    , DataRequestPending(false)
    , BlockingRequestPending(false)
    , BlockingDataRequestPending(false)
    , GetRequestPending(true)
    , GetDataRequestPending(true)
    , BlockingGetRequestPending(false)
    , BlockingGetDataRequestPending(false)
    , ResponsePending(false)
    , BlockingResponsePending(false)
    , GetResponsePending(true)
    , BlockingGetResponsePending(false)
    , RequestTogglePE(false)
    , DataRequestTogglePE(false)
    , ResponseTogglePE(false)
  {

     RequestPendingPE[0] = false;
     RequestPendingPE[1] = false;
     DataRequestPendingPE[0] = false;
     DataRequestPendingPE[1] = false;
     ResponsePendingPE[0] = false;
     ResponsePendingPE[1] = false;

  }

  // States for non-blocking and blocking synchronization
  bool RequestStart;
  bool RequestEnd;
  bool ResponseStart;
  bool ResponseEnd;
  bool DataRequestStart;
  bool DataRequestEnd;
  bool RequestPending;
  bool DataRequestPending;
  bool BlockingRequestPending;
  bool BlockingDataRequestPending;
  bool GetRequestPending;
  bool GetDataRequestPending;
  bool BlockingGetRequestPending;
  bool BlockingGetDataRequestPending;
  bool ResponsePending;
  bool BlockingResponsePending;
  bool GetResponsePending;
  bool BlockingGetResponsePending;
  bool RequestTogglePE;
  bool DataRequestTogglePE;
  bool ResponseTogglePE;
  bool RequestPendingPE[2];
  bool DataRequestPendingPE[2];
  bool ResponsePendingPE[2];

  // Events for blocking synchronization
  sc_event RequestStartEvent;
  sc_event RequestEndEvent;
  sc_event DataRequestStartEvent;
  sc_event DataRequestEndEvent;
  sc_event ResponseStartEvent;
  sc_event ResponseEndEvent;
  sc_event RequestEndEventN;
  sc_event DataRequestEndEventN;
  sc_event ResponseEndEventN;

  // default event to indicate port access
  sc_event StartEvent;

  // 
 private:
};

#endif // _TL_Comm_CL
